/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.platform.persistence.jdbc.dialect.impl;

import net.ymate.platform.core.util.ExpressionUtils;
import net.ymate.platform.persistence.jdbc.JDBC;
import net.ymate.platform.persistence.jdbc.dialect.AbstractDialect;
import org.apache.commons.lang.StringUtils;

public class SQLServerDialect
extends AbstractDialect {
    private static final String SELECT = "SELECT";
    private static final String DISTINCT = "DISTINCT";

    public SQLServerDialect() {
        super("[", "]");
    }

    @Override
    public String getName() {
        return JDBC.DATABASE.SQLSERVER.name();
    }

    @Override
    public String buildPagedQuerySQL(String originSql, int page, int pageSize) {
        int _limit = (page - 1) * pageSize;
        String _tmpSQL = StringUtils.trim((String)originSql);
        if (StringUtils.startsWithIgnoreCase((String)_tmpSQL, (String)SELECT)) {
            _tmpSQL = StringUtils.trim((String)StringUtils.substring((String)_tmpSQL, (int)SELECT.length()));
        }
        boolean distinct = false;
        if (StringUtils.startsWithIgnoreCase((String)_tmpSQL, (String)DISTINCT)) {
            _tmpSQL = StringUtils.substring((String)_tmpSQL, (int)DISTINCT.length());
            distinct = true;
        }
        return ExpressionUtils.bind((String)"SELECT * FROM (SELECT ROW_NUMBER() OVER(ORDER BY __tc__) __rn__, * FROM (SELECT ${_distinct} TOP ${_limit} 0 __tc__, ${_sql}) t) tt WHERE __rn__ > ${_offset}").set("_distinct", distinct ? DISTINCT : "").set("_limit", String.valueOf(_limit + pageSize)).set("_sql", _tmpSQL).set("_offset", String.valueOf(_limit)).getResult();
    }
}

