/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.platform.persistence.jdbc.base.impl;

import java.io.Serializable;
import java.sql.ResultSet;
import net.ymate.platform.core.lang.BlurObject;
import net.ymate.platform.core.util.ClassUtils;
import net.ymate.platform.persistence.base.EntityMeta;
import net.ymate.platform.persistence.base.IEntity;
import net.ymate.platform.persistence.jdbc.base.AbstractResultSetHandler;

public class EntityResultSetHandler<T extends IEntity>
extends AbstractResultSetHandler<T> {
    private final Class<T> __entityClass;
    private final EntityMeta __entityMeta;

    public EntityResultSetHandler() {
        this.__entityClass = (Class)ClassUtils.getParameterizedTypes(this.getClass()).get(0);
        this.__entityMeta = EntityMeta.createAndGet(this.__entityClass);
    }

    public EntityResultSetHandler(Class<T> entityClass) {
        this.__entityClass = entityClass;
        this.__entityMeta = EntityMeta.createAndGet(entityClass);
    }

    @Override
    protected T __doProcessResultRow(ResultSet resultSet) throws Exception {
        IEntity _returnValue = (IEntity)this.__entityClass.newInstance();
        Object _primaryKeyObject = null;
        if (this.__entityMeta.isMultiplePrimaryKey()) {
            _primaryKeyObject = this.__entityMeta.getPrimaryKeyClass().newInstance();
            _returnValue.setId((Serializable)_primaryKeyObject);
        }
        for (int _idx = 0; _idx < this.__doGetColumnCount(); ++_idx) {
            EntityMeta.PropertyMeta _meta = this.__entityMeta.getPropertyByName(this._doGetColumnMeta(_idx).getName().toLowerCase());
            if (_meta == null) continue;
            Object _fValue = BlurObject.bind((Object)resultSet.getObject(_idx + 1)).toObjectValue(_meta.getField().getType());
            if (this.__entityMeta.isPrimaryKey(_meta.getName()) && this.__entityMeta.isMultiplePrimaryKey()) {
                _meta.getField().set(_primaryKeyObject, _fValue);
                continue;
            }
            _meta.getField().set(_returnValue, _fValue);
        }
        return (T)_returnValue;
    }
}

