/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.platform.persistence.jdbc.base.impl;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import net.ymate.platform.persistence.base.Type;
import net.ymate.platform.persistence.jdbc.IConnectionHolder;
import net.ymate.platform.persistence.jdbc.base.AbstractOperator;
import net.ymate.platform.persistence.jdbc.base.AccessorEventContext;
import net.ymate.platform.persistence.jdbc.base.IAccessorConfig;
import net.ymate.platform.persistence.jdbc.base.IQueryOperator;
import net.ymate.platform.persistence.jdbc.base.IResultSetHandler;
import net.ymate.platform.persistence.jdbc.base.impl.BaseAccessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultQueryOperator<T>
extends AbstractOperator
implements IQueryOperator<T> {
    private static final Log _LOG = LogFactory.getLog(DefaultQueryOperator.class);
    private IResultSetHandler<T> resultSetHandler;
    private List<T> resultSet;
    private int maxRow;

    public DefaultQueryOperator(String sql, IConnectionHolder connectionHolder, IResultSetHandler<T> resultSetHandler) {
        this(sql, connectionHolder, null, resultSetHandler);
    }

    public DefaultQueryOperator(String sql, IConnectionHolder connectionHolder, IResultSetHandler<T> resultSetHandler, int maxRow) {
        this(sql, connectionHolder, null, resultSetHandler, maxRow);
    }

    public DefaultQueryOperator(String sql, IConnectionHolder connectionHolder, IAccessorConfig accessorConfig, IResultSetHandler<T> resultSetHandler) {
        this(sql, connectionHolder, accessorConfig, resultSetHandler, 0);
    }

    public DefaultQueryOperator(String sql, IConnectionHolder connectionHolder, IAccessorConfig accessorConfig, IResultSetHandler<T> resultSetHandler, int maxRow) {
        super(sql, connectionHolder, accessorConfig);
        this.resultSetHandler = resultSetHandler;
        this.maxRow = maxRow;
    }

    @Override
    protected int __doExecute() throws Exception {
        int n;
        Statement _statement = null;
        ResultSet _resultSet = null;
        AccessorEventContext _context = null;
        boolean _hasEx = false;
        try {
            BaseAccessor _accessor = new BaseAccessor(this.getAccessorConfig());
            _statement = _accessor.getPreparedStatement(this.getConnectionHolder().getConnection(), this.getSQL());
            if (this.maxRow > 0) {
                _statement.setMaxRows(this.maxRow);
            }
            this.__doSetParameters((PreparedStatement)_statement);
            if (this.getAccessorConfig() != null) {
                _context = new AccessorEventContext(_statement, Type.OPT.QUERY);
                this.getAccessorConfig().beforeStatementExecution(_context);
            }
            _resultSet = _statement.executeQuery();
            this.resultSet = this.getResultSetHandler().handle(_resultSet);
            n = this.resultSet.size();
        }
        catch (Exception ex) {
            try {
                _hasEx = true;
                throw ex;
            }
            catch (Throwable throwable) {
                if (!_hasEx && this.getAccessorConfig() != null && _context != null) {
                    this.getAccessorConfig().afterStatementExecution(_context);
                }
                if (_resultSet != null) {
                    _resultSet.close();
                }
                if (_statement != null) {
                    _statement.close();
                }
                throw throwable;
            }
        }
        if (!_hasEx && this.getAccessorConfig() != null && _context != null) {
            this.getAccessorConfig().afterStatementExecution(_context);
        }
        if (_resultSet != null) {
            _resultSet.close();
        }
        if (_statement != null) {
            _statement.close();
        }
        return n;
    }

    @Override
    public IResultSetHandler<T> getResultSetHandler() {
        return this.resultSetHandler;
    }

    @Override
    public List<T> getResultSet() {
        return this.resultSet;
    }

    @Override
    public int getMaxRow() {
        return this.maxRow;
    }
}

