/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.platform.persistence.jdbc.base;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.ymate.platform.core.util.ExpressionUtils;
import net.ymate.platform.persistence.base.Type;
import net.ymate.platform.persistence.jdbc.DataSourceCfgMeta;
import net.ymate.platform.persistence.jdbc.IConnectionHolder;
import net.ymate.platform.persistence.jdbc.base.IAccessorConfig;
import net.ymate.platform.persistence.jdbc.base.IOperator;
import net.ymate.platform.persistence.jdbc.base.SQLParameter;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.StopWatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractOperator
implements IOperator {
    private static final Log _LOG = LogFactory.getLog(AbstractOperator.class);
    protected String sql;
    private IConnectionHolder connectionHolder;
    private IAccessorConfig accessorConfig;
    private List<SQLParameter> parameters;
    protected long expenseTime;
    protected boolean executed;

    public AbstractOperator(String sql, IConnectionHolder connectionHolder) {
        this(sql, connectionHolder, null);
    }

    public AbstractOperator(String sql, IConnectionHolder connectionHolder, IAccessorConfig accessorConfig) {
        this.sql = sql;
        this.connectionHolder = connectionHolder;
        this.accessorConfig = accessorConfig;
        this.parameters = new ArrayList<SQLParameter>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Exception {
        if (!this.executed) {
            DataSourceCfgMeta _meta;
            StopWatch _time = new StopWatch();
            _time.start();
            int _effectCounts = 0;
            try {
                _effectCounts = this.__doExecute();
                this.executed = true;
            }
            catch (Throwable throwable) {
                DataSourceCfgMeta _meta2;
                _time.stop();
                this.expenseTime = _time.getTime();
                if (_LOG.isInfoEnabled() && (_meta2 = this.connectionHolder.getDataSourceCfgMeta()).isShowSQL()) {
                    String _logStr = ExpressionUtils.bind((String)"[${sql}]${param}[${count}][${time}]").set("sql", StringUtils.defaultIfBlank((String)this.sql, (String)"@NULL")).set("param", this.__doSerializeParameters()).set("count", _effectCounts + "").set("time", this.expenseTime + "ms").getResult();
                    StringBuilder _stackSB = new StringBuilder(_logStr);
                    if (_meta2.isStackTraces()) {
                        String[] _tracePackages = StringUtils.split((String)_meta2.getStackTracePackage(), (String)"|");
                        StackTraceElement[] _stacks = new Throwable().getStackTrace();
                        if (_stacks != null && _stacks.length > 0) {
                            int _depth;
                            int n = _meta2.getStackTraceDepth() <= 0 ? _stacks.length : (_depth = _meta2.getStackTraceDepth() > _stacks.length ? _stacks.length : _meta2.getStackTraceDepth());
                            if (_depth > 0) {
                                for (int _idx = 0; _idx < _depth; ++_idx) {
                                    if (_tracePackages != null && _tracePackages.length > 0 && (StringUtils.contains((String)_stacks[_idx].getClassName(), (String)"$$EnhancerByCGLIB$$") || !StringUtils.startsWithAny((String)_stacks[_idx].getClassName(), (String[])_tracePackages))) continue;
                                    _stackSB.append("\n\t--> ").append(_stacks[_idx]);
                                }
                            }
                        }
                    }
                    _LOG.info((Object)_stackSB.toString());
                }
                throw throwable;
            }
            _time.stop();
            this.expenseTime = _time.getTime();
            if (_LOG.isInfoEnabled() && (_meta = this.connectionHolder.getDataSourceCfgMeta()).isShowSQL()) {
                String _logStr = ExpressionUtils.bind((String)"[${sql}]${param}[${count}][${time}]").set("sql", StringUtils.defaultIfBlank((String)this.sql, (String)"@NULL")).set("param", this.__doSerializeParameters()).set("count", _effectCounts + "").set("time", this.expenseTime + "ms").getResult();
                StringBuilder _stackSB = new StringBuilder(_logStr);
                if (_meta.isStackTraces()) {
                    String[] _tracePackages = StringUtils.split((String)_meta.getStackTracePackage(), (String)"|");
                    StackTraceElement[] _stacks = new Throwable().getStackTrace();
                    if (_stacks != null && _stacks.length > 0) {
                        int _depth;
                        int n = _meta.getStackTraceDepth() <= 0 ? _stacks.length : (_depth = _meta.getStackTraceDepth() > _stacks.length ? _stacks.length : _meta.getStackTraceDepth());
                        if (_depth > 0) {
                            for (int _idx = 0; _idx < _depth; ++_idx) {
                                if (_tracePackages != null && _tracePackages.length > 0 && (StringUtils.contains((String)_stacks[_idx].getClassName(), (String)"$$EnhancerByCGLIB$$") || !StringUtils.startsWithAny((String)_stacks[_idx].getClassName(), (String[])_tracePackages))) continue;
                                _stackSB.append("\n\t--> ").append(_stacks[_idx]);
                            }
                        }
                    }
                }
                _LOG.info((Object)_stackSB.toString());
            }
        }
    }

    protected String __doSerializeParameters() {
        return this.parameters.toString();
    }

    protected abstract int __doExecute() throws Exception;

    protected void __doSetParameters(PreparedStatement statement) throws SQLException {
        int _idx = 1;
        for (SQLParameter _param : this.getParameters()) {
            if (_param.getValue() == null) {
                statement.setNull(_idx++, 0);
                continue;
            }
            if (_param.getType() != null && !Type.FIELD.UNKNOWN.equals((Object)_param.getType())) {
                statement.setObject(_idx++, _param.getValue(), _param.getType().getType());
                continue;
            }
            statement.setObject(_idx++, _param.getValue());
        }
    }

    @Override
    public boolean isExecuted() {
        return this.executed;
    }

    @Override
    public String getSQL() {
        return this.sql;
    }

    @Override
    public IAccessorConfig getAccessorConfig() {
        return this.accessorConfig;
    }

    @Override
    public void setAccessorConfig(IAccessorConfig accessorConfig) {
        this.accessorConfig = accessorConfig;
    }

    @Override
    public IConnectionHolder getConnectionHolder() {
        return this.connectionHolder;
    }

    @Override
    public long getExpenseTime() {
        return this.expenseTime;
    }

    @Override
    public List<SQLParameter> getParameters() {
        return this.parameters;
    }

    @Override
    public IOperator addParameter(SQLParameter parameter) {
        if (parameter != null) {
            this.parameters.add(parameter);
        }
        return this;
    }

    @Override
    public IOperator addParameter(Object parameter) {
        if (parameter == null) {
            this.parameters.add(new SQLParameter(Type.FIELD.UNKNOWN, null));
        } else if (parameter instanceof SQLParameter) {
            this.parameters.add((SQLParameter)parameter);
        } else {
            this.parameters.add(new SQLParameter(parameter));
        }
        return this;
    }
}

