/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.platform.persistence.jdbc.transaction.impl;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import net.ymate.platform.core.util.UUIDUtils;
import net.ymate.platform.persistence.jdbc.IConnectionHolder;
import net.ymate.platform.persistence.jdbc.JDBC;
import net.ymate.platform.persistence.jdbc.transaction.ITransaction;

public class DefaultTransaction
implements ITransaction {
    private String __id = UUIDUtils.UUID();
    private JDBC.TRANSACTION __level;
    private Map<String, TransactionMeta> __transMetas = new HashMap<String, TransactionMeta>();

    public DefaultTransaction() {
    }

    public DefaultTransaction(JDBC.TRANSACTION level) {
        this();
        this.setLevel(level);
    }

    @Override
    public JDBC.TRANSACTION getLevel() {
        return this.__level;
    }

    @Override
    public void setLevel(JDBC.TRANSACTION level) {
        if (level == null || this.__level != null && this.__level.getLevel() > 0) {
            return;
        }
        this.__level = level;
    }

    @Override
    public String getId() {
        return this.__id;
    }

    @Override
    public void commit() throws SQLException {
        for (TransactionMeta _meta : this.__transMetas.values()) {
            _meta.connectionHolder.getConnection().commit();
        }
    }

    @Override
    public void rollback() throws SQLException {
        for (TransactionMeta _meta : this.__transMetas.values()) {
            _meta.connectionHolder.getConnection().rollback();
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            for (TransactionMeta _meta : this.__transMetas.values()) {
                _meta.release();
            }
        }
        finally {
            this.__transMetas = null;
        }
    }

    @Override
    public IConnectionHolder getConnectionHolder(String dsName) {
        if (this.__transMetas.containsKey(dsName)) {
            return this.__transMetas.get((Object)dsName).connectionHolder;
        }
        return null;
    }

    @Override
    public void registerConnectionHolder(IConnectionHolder connectionHolder) throws SQLException {
        String _dsName = connectionHolder.getDataSourceCfgMeta().getName();
        if (!this.__transMetas.containsKey(_dsName)) {
            this.__transMetas.put(_dsName, new TransactionMeta(connectionHolder, this.getLevel()));
        }
    }

    private static class TransactionMeta {
        IConnectionHolder connectionHolder;

        TransactionMeta(IConnectionHolder connectionHolder, JDBC.TRANSACTION initLevel) throws SQLException {
            this.connectionHolder = connectionHolder;
            if (this.connectionHolder.getConnection().getAutoCommit()) {
                this.connectionHolder.getConnection().setAutoCommit(false);
            }
            if (initLevel != null && initLevel.getLevel() != connectionHolder.getConnection().getTransactionIsolation()) {
                this.connectionHolder.getConnection().setTransactionIsolation(initLevel.getLevel());
            }
        }

        void release() throws SQLException {
            try {
                if (this.connectionHolder != null) {
                    this.connectionHolder.release();
                }
            }
            finally {
                this.connectionHolder = null;
            }
        }
    }
}

