/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.platform.persistence.jdbc.support;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.ymate.platform.core.lang.BlurObject;
import net.ymate.platform.core.util.ClassUtils;
import net.ymate.platform.persistence.IResultSet;
import net.ymate.platform.persistence.base.EntityMeta;
import net.ymate.platform.persistence.base.IEntity;

public final class ResultSetHelper {
    private List<?> __dataSet;
    private final boolean __isArray;
    private int __rowCount;
    private int __columnCount;
    private boolean __clearFlag;
    private String[] __columnNames;

    public static ResultSetHelper bind(Object[] data) {
        ArrayList<Object[]> _data = new ArrayList<Object[]>();
        _data.add(data);
        return ResultSetHelper.bind(_data);
    }

    public static ResultSetHelper bind(Map<String, Object> data) {
        ArrayList<Map<String, Object>> _data = new ArrayList<Map<String, Object>>();
        _data.add(data);
        return ResultSetHelper.bind(_data);
    }

    public static ResultSetHelper bind(IResultSet<?> resultSet) {
        return ResultSetHelper.bind(resultSet.getResultData());
    }

    public static ResultSetHelper bind(List<?> dataSet) {
        if (dataSet != null && !dataSet.isEmpty()) {
            Object _value = dataSet.get(0);
            if (_value instanceof Map) {
                return new ResultSetHelper(dataSet, false);
            }
            if (_value instanceof Object[]) {
                return new ResultSetHelper(dataSet, true);
            }
        }
        return null;
    }

    private ResultSetHelper(List<?> resultSet, boolean isArray) {
        block5: {
            this.__dataSet = resultSet;
            this.__isArray = isArray;
            if (this.__dataSet == null) break block5;
            this.__rowCount = this.__dataSet.size();
            if (this.__rowCount > 0) {
                this.__columnCount = this.__isArray ? ((Object[])this.__dataSet.get(0)).length : ((Map)this.__dataSet.get(0)).size();
                if (this.__isArray) {
                    Object[] _obj = (Object[])this.__dataSet.get(0);
                    this.__columnNames = new String[_obj.length];
                    for (int i = 0; i < _obj.length; ++i) {
                        Object[] _columnObj = (Object[])_obj[i];
                        this.__columnNames[i] = (String)_columnObj[0];
                    }
                } else {
                    Map _map = (Map)this.__dataSet.get(0);
                    Iterator _itemIt = _map.keySet().iterator();
                    this.__columnNames = new String[_map.keySet().size()];
                    int _idx = 0;
                    while (_itemIt.hasNext()) {
                        this.__columnNames[_idx] = (String)_itemIt.next();
                        ++_idx;
                    }
                }
            }
        }
    }

    public String[] getColumnNames() {
        return this.__columnNames;
    }

    public void clearAll() {
        if (this.__dataSet != null) {
            this.__dataSet.clear();
            this.__dataSet = null;
        }
        this.__columnNames = null;
        this.__clearFlag = true;
    }

    protected void finalize() throws Throwable {
        if (!this.__clearFlag) {
            this.clearAll();
        }
        super.finalize();
    }

    public void forEach(ItemHandler handler) throws Exception {
        this.forEach(1, handler);
    }

    public void forEach(int step, ItemHandler handler) throws Exception {
        step = step > 0 ? step : 1;
        for (int _idx = step - 1; _idx < this.__rowCount && handler.handle(new ItemWrapper(this.__dataSet.get(_idx), this.__isArray), _idx); _idx += step) {
        }
    }

    public ItemWrapper firstItemWrapper() {
        return new ItemWrapper(this.__dataSet.get(0), this.__isArray);
    }

    public class ItemWrapper {
        private final Object __item;
        private final boolean __isArray;

        public ItemWrapper(Object item, boolean isArray) {
            this.__item = item;
            this.__isArray = isArray;
        }

        public int getColumnCount() {
            return ResultSetHelper.this.__columnCount;
        }

        public String[] getColumnNames() {
            return ResultSetHelper.this.__columnNames;
        }

        public Object getObject(String columnName) {
            return this.__doGetObject(columnName);
        }

        private Object __doGetObject(String columnName) {
            Object _returnValue;
            block2: {
                block3: {
                    _returnValue = null;
                    if (!this.__isArray) break block3;
                    Object[] _obj = (Object[])this.__item;
                    for (int i = 0; i < ResultSetHelper.this.__columnNames.length; ++i) {
                        if (!ResultSetHelper.this.__columnNames[i].equalsIgnoreCase(columnName)) continue;
                        Object[] _object = (Object[])_obj[i];
                        _returnValue = _object[1];
                        break block2;
                    }
                    break block2;
                }
                Map _map = (Map)this.__item;
                _returnValue = _map.get(columnName);
                if (_returnValue != null) break block2;
                for (String __columnName : ResultSetHelper.this.__columnNames) {
                    if (!__columnName.equalsIgnoreCase(columnName)) continue;
                    _returnValue = _map.get(__columnName);
                    break;
                }
            }
            return _returnValue;
        }

        public Object getObject(int index) {
            return this.__doGetObject(index);
        }

        private Object __doGetObject(int index) {
            Object _returnValue = null;
            if (index >= 0 && index < ResultSetHelper.this.__columnCount) {
                if (this.__isArray) {
                    Object[] _obj = (Object[])this.__item;
                    Object[] _object = (Object[])_obj[index];
                    _returnValue = _object[1];
                } else {
                    Map _map = (Map)this.__item;
                    Iterator _itemIt = _map.values().iterator();
                    int i = 0;
                    while (_itemIt.hasNext()) {
                        _returnValue = _itemIt.next();
                        if (index == i) break;
                        _returnValue = null;
                        ++i;
                    }
                }
            }
            return _returnValue;
        }

        public Time getAsTime(int i) {
            Object o = this.getObject(i);
            if (o == null) {
                return null;
            }
            if (o instanceof Time) {
                return (Time)o;
            }
            return new Time(((Date)o).getTime());
        }

        public Time getAsTime(String columnName) {
            Object o = this.getObject(columnName);
            if (o == null) {
                return null;
            }
            if (o instanceof Time) {
                return (Time)o;
            }
            return new Time(((Date)o).getTime());
        }

        public Timestamp getAsTimestamp(int i) {
            Object o = this.getObject(i);
            if (o == null) {
                return null;
            }
            if (o instanceof Timestamp) {
                return (Timestamp)o;
            }
            return new Timestamp(((Date)o).getTime());
        }

        public Timestamp getAsTimestamp(String columnName) {
            Object o = this.getObject(columnName);
            if (o == null) {
                return null;
            }
            if (o instanceof Timestamp) {
                return (Timestamp)o;
            }
            return new Timestamp(((Date)o).getTime());
        }

        public Date getAsDate(int i) {
            Object o = this.getObject(i);
            if (o == null) {
                return null;
            }
            if (o instanceof Date) {
                return (Date)o;
            }
            return new Date(((Timestamp)o).getTime());
        }

        public Date getAsDate(String columnName) {
            Object o = this.getObject(columnName);
            if (o == null) {
                return null;
            }
            if (o instanceof Date) {
                return (Date)o;
            }
            return new Date(((Timestamp)o).getTime());
        }

        public Float getAsFloat(int i) {
            Object o = this.getObject(i);
            if (o == null) {
                return null;
            }
            return Float.valueOf(BlurObject.bind((Object)o).toFloatValue());
        }

        public Float getAsFloat(String columnName) {
            Object o = this.getObject(columnName);
            if (o == null) {
                return null;
            }
            return Float.valueOf(BlurObject.bind((Object)o).toFloatValue());
        }

        public Double getAsDouble(int i) {
            Object o = this.getObject(i);
            if (o == null) {
                return null;
            }
            return BlurObject.bind((Object)o).toDoubleValue();
        }

        public Double getAsDouble(String columnName) {
            Object o = this.getObject(columnName);
            if (o == null) {
                return null;
            }
            return BlurObject.bind((Object)o).toDoubleValue();
        }

        public Byte getAsByte(int i) {
            Object o = this.getObject(i);
            if (o == null) {
                return null;
            }
            if (o instanceof Byte) {
                return (Byte)o;
            }
            if (o instanceof Integer) {
                return ((Integer)o).byteValue();
            }
            return ((BigDecimal)o).byteValue();
        }

        public Byte getAsByte(String columnName) {
            Object o = this.getObject(columnName);
            if (o == null) {
                return null;
            }
            if (o instanceof Byte) {
                return (Byte)o;
            }
            if (o instanceof Integer) {
                return ((Integer)o).byteValue();
            }
            return ((BigDecimal)o).byteValue();
        }

        public Short getAsShort(int i) {
            Object o = this.getObject(i);
            if (o == null) {
                return null;
            }
            if (o instanceof Short) {
                return (Short)o;
            }
            if (o instanceof Integer) {
                return ((Integer)o).shortValue();
            }
            return ((BigDecimal)o).shortValue();
        }

        public Short getAsShort(String columnName) {
            Object o = this.getObject(columnName);
            if (o == null) {
                return null;
            }
            if (o instanceof Short) {
                return (Short)o;
            }
            if (o instanceof Integer) {
                return ((Integer)o).shortValue();
            }
            return ((BigDecimal)o).shortValue();
        }

        public Long getAsLong(int i) {
            Object o = this.getObject(i);
            if (o == null) {
                return null;
            }
            return BlurObject.bind((Object)o).toLongValue();
        }

        public Long getAsLong(String columnName) {
            Object o = this.getObject(columnName);
            if (o == null) {
                return null;
            }
            return BlurObject.bind((Object)o).toLongValue();
        }

        public BigDecimal getAsBigDecimal(int i) {
            Object o = this.getObject(i);
            if (o == null) {
                return null;
            }
            return (BigDecimal)o;
        }

        public BigDecimal getAsBigDecimal(String columnName) {
            Object o = this.getObject(columnName);
            if (o == null) {
                return null;
            }
            return (BigDecimal)o;
        }

        public Integer getAsInteger(int i) {
            Object o = this.getObject(i);
            if (o == null) {
                return null;
            }
            return BlurObject.bind((Object)o).toIntValue();
        }

        public Integer getAsInteger(String columnName) {
            Object o = this.getObject(columnName);
            if (o == null) {
                return null;
            }
            return new BlurObject(o).toIntValue();
        }

        public Character getAsChar(String columnName) {
            Object o = this.getObject(columnName);
            if (o == null) {
                return null;
            }
            if (o instanceof Character) {
                return (Character)o;
            }
            return Character.valueOf(o.toString().charAt(0));
        }

        public Character getAsChar(int index) {
            Object o = this.getObject(index);
            if (o == null) {
                return null;
            }
            if (o instanceof Character) {
                return (Character)o;
            }
            return Character.valueOf(o.toString().charAt(0));
        }

        public String getAsString(String columnName) {
            Object v = this.getObject(columnName);
            if (v != null) {
                return v.toString();
            }
            return null;
        }

        public String getAsString(int index) {
            Object v = this.getObject(index);
            if (v != null) {
                return v.toString();
            }
            return null;
        }

        public <T extends IEntity> T toEntity(T entityObject) throws Exception {
            EntityMeta _entityMeta = EntityMeta.createAndGet(entityObject.getClass());
            Object _primaryKeyObject = null;
            if (_entityMeta.isMultiplePrimaryKey()) {
                _primaryKeyObject = _entityMeta.getPrimaryKeyClass().newInstance();
                entityObject.setId((Serializable)_primaryKeyObject);
            }
            for (EntityMeta.PropertyMeta _meta : _entityMeta.getProperties()) {
                Object _fValue = this.getObject(_meta.getName());
                if (_fValue == null) continue;
                if (_entityMeta.isPrimaryKey(_meta.getName()) && _entityMeta.isMultiplePrimaryKey()) {
                    _meta.getField().set(_primaryKeyObject, _fValue);
                    continue;
                }
                _meta.getField().set(entityObject, _fValue);
            }
            return entityObject;
        }

        public <T> T toObject(T valueObject) throws Exception {
            ClassUtils.BeanWrapper _wrapper = ClassUtils.wrapper(valueObject);
            for (String _fieldName : _wrapper.getFieldNames()) {
                String _columnName = EntityMeta.fieldNameToPropertyName((String)_fieldName, (int)0);
                Object _value = this.getObject(_columnName);
                if (_value == null) continue;
                _wrapper.setValue(_fieldName, BlurObject.bind((Object)_value).toObjectValue(_wrapper.getFieldType(_fieldName)));
            }
            return valueObject;
        }
    }

    public static interface ItemHandler {
        public boolean handle(ItemWrapper var1, int var2) throws Exception;
    }
}

