/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.platform.persistence.jdbc.support;

import com.alibaba.fastjson.annotation.JSONField;
import java.io.Serializable;
import net.ymate.platform.core.util.ClassUtils;
import net.ymate.platform.persistence.Fields;
import net.ymate.platform.persistence.IResultSet;
import net.ymate.platform.persistence.IShardingable;
import net.ymate.platform.persistence.Page;
import net.ymate.platform.persistence.base.EntityMeta;
import net.ymate.platform.persistence.base.IEntity;
import net.ymate.platform.persistence.jdbc.IConnectionHolder;
import net.ymate.platform.persistence.jdbc.JDBC;
import net.ymate.platform.persistence.jdbc.impl.DefaultSession;
import net.ymate.platform.persistence.jdbc.query.Cond;
import net.ymate.platform.persistence.jdbc.query.Delete;
import net.ymate.platform.persistence.jdbc.query.EntitySQL;
import net.ymate.platform.persistence.jdbc.query.IDBLocker;
import net.ymate.platform.persistence.jdbc.query.SQL;
import net.ymate.platform.persistence.jdbc.query.Where;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public abstract class BaseEntity<Entity extends IEntity, PK extends Serializable>
implements IEntity<PK> {
    private final Class<Entity> __entityClass = (Class)ClassUtils.getParameterizedTypes(this.getClass()).get(0);
    private IConnectionHolder __connectionHolder;
    private IShardingable __shardingable;
    private String __dsName;

    @JSONField(serialize=false)
    public IConnectionHolder getConnectionHolder() {
        return this.__connectionHolder;
    }

    @JSONField(deserialize=false)
    public void setConnectionHolder(IConnectionHolder connectionHolder) {
        this.__connectionHolder = connectionHolder;
        this.__dsName = this.__connectionHolder != null ? this.__connectionHolder.getDataSourceCfgMeta().getName() : null;
    }

    @JSONField(serialize=false)
    public IShardingable getShardingable() {
        return this.__shardingable;
    }

    @JSONField(deserialize=false)
    public void setShardingable(IShardingable shardingable) {
        this.__shardingable = shardingable;
    }

    @JSONField(serialize=false)
    public String getDataSourceName() {
        return this.__dsName;
    }

    @JSONField(deserialize=false)
    public void setDataSourceName(String dsName) {
        this.__dsName = StringUtils.trimToNull((String)dsName);
    }

    protected Class<Entity> getEntityClass() {
        return this.__entityClass;
    }

    protected IConnectionHolder __doGetConnectionHolderSafed() throws Exception {
        if (this.__connectionHolder == null || this.__connectionHolder.getConnection() == null || this.__connectionHolder.getConnection().isClosed()) {
            this.__connectionHolder = StringUtils.isNotBlank((String)this.__dsName) ? JDBC.get().getConnectionHolder(this.__dsName) : JDBC.get().getDefaultConnectionHolder();
        }
        return this.__connectionHolder;
    }

    public void entityCreate() throws Exception {
        DefaultSession _session = new DefaultSession(this.__doGetConnectionHolderSafed());
        try {
            _session.executeForUpdate(SQL.create(_session.getConnectionHolder().getDialect().buildCreateSQL(this.__entityClass, _session.getConnectionHolder().getDataSourceCfgMeta().getTablePrefix(), this.getShardingable())));
        }
        finally {
            _session.close();
        }
    }

    public void entityDrop() throws Exception {
        DefaultSession _session = new DefaultSession(this.__doGetConnectionHolderSafed());
        try {
            _session.executeForUpdate(SQL.create(_session.getConnectionHolder().getDialect().buildDropSQL(this.__entityClass, _session.getConnectionHolder().getDataSourceCfgMeta().getTablePrefix(), this.getShardingable())));
        }
        finally {
            _session.close();
        }
    }

    public Entity load() throws Exception {
        return this.load(null, null);
    }

    public Entity load(Fields fields) throws Exception {
        return this.load(fields, null);
    }

    public Entity load(IDBLocker dbLocker) throws Exception {
        return this.load(null, dbLocker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entity load(Fields fields, IDBLocker dbLocker) throws Exception {
        DefaultSession _session = new DefaultSession(this.__doGetConnectionHolderSafed());
        try {
            EntitySQL<Entity> _entitySQL = EntitySQL.create(this.getEntityClass());
            if (fields != null) {
                _entitySQL.field(fields);
            }
            if (dbLocker != null) {
                _entitySQL.forUpdate(dbLocker);
            }
            Entity Entity = _session.find(_entitySQL, this.getId(), this.getShardingable());
            return Entity;
        }
        finally {
            _session.close();
        }
    }

    public Entity save() throws Exception {
        DefaultSession _session = new DefaultSession(this.__doGetConnectionHolderSafed());
        try {
            BaseEntity baseEntity = _session.insert(this, this.getShardingable());
            return (Entity)baseEntity;
        }
        finally {
            _session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entity save(Fields fields) throws Exception {
        DefaultSession _session = new DefaultSession(this.__doGetConnectionHolderSafed());
        try {
            BaseEntity baseEntity = _session.insert(this, fields, this.getShardingable());
            return (Entity)baseEntity;
        }
        finally {
            _session.close();
        }
    }

    public Entity saveOrUpdate() throws Exception {
        return this.saveOrUpdate(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entity saveOrUpdate(Fields fields) throws Exception {
        DefaultSession _session = new DefaultSession(this.__doGetConnectionHolderSafed());
        try {
            Entity _t;
            EntitySQL<Entity> _entitySQL = EntitySQL.create(this.getEntityClass());
            if (fields != null) {
                _entitySQL.field(fields);
            }
            if ((_t = _session.find(_entitySQL, this.getId(), this.getShardingable())) == null) {
                BaseEntity baseEntity = _session.insert(this, this.getShardingable());
                return (Entity)baseEntity;
            }
            BaseEntity baseEntity = _session.update(this, fields, this.getShardingable());
            return (Entity)baseEntity;
        }
        finally {
            _session.close();
        }
    }

    public Entity update() throws Exception {
        return this.update(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entity update(Fields fields) throws Exception {
        DefaultSession _session = new DefaultSession(this.__doGetConnectionHolderSafed());
        try {
            BaseEntity baseEntity = _session.update(this, fields, this.getShardingable());
            return (Entity)baseEntity;
        }
        finally {
            _session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entity delete() throws Exception {
        DefaultSession _session = new DefaultSession(this.__doGetConnectionHolderSafed());
        try {
            if (null != this.getId()) {
                if (_session.delete(this.getEntityClass(), this.getId(), this.getShardingable()) > 0) {
                    BaseEntity baseEntity = this;
                    return (Entity)baseEntity;
                }
            } else {
                Cond _cond = BaseEntity.buildEntityCond(this);
                if (StringUtils.isNotBlank((String)_cond.toString()) && _session.executeForUpdate(((Delete)((Delete)Delete.create().set(_session)).shardingable(this.getShardingable())).from(this.getEntityClass()).where(Where.create(_cond)).toSQL()) > 0) {
                    BaseEntity baseEntity = this;
                    return (Entity)baseEntity;
                }
            }
            Entity Entity = null;
            return Entity;
        }
        finally {
            _session.close();
        }
    }

    public IResultSet<Entity> find() throws Exception {
        return this.find(Where.create(BaseEntity.buildEntityCond(this)), null, null, null);
    }

    public IResultSet<Entity> find(IDBLocker dbLocker) throws Exception {
        return this.find(Where.create(BaseEntity.buildEntityCond(this)), null, null, dbLocker);
    }

    public IResultSet<Entity> find(Page page) throws Exception {
        return this.find(Where.create(BaseEntity.buildEntityCond(this)), null, page, null);
    }

    public IResultSet<Entity> find(Page page, IDBLocker dbLocker) throws Exception {
        return this.find(Where.create(BaseEntity.buildEntityCond(this)), null, page, dbLocker);
    }

    public IResultSet<Entity> find(Fields fields) throws Exception {
        return this.find(Where.create(BaseEntity.buildEntityCond(this)), fields, null, null);
    }

    public IResultSet<Entity> find(Fields fields, IDBLocker dbLocker) throws Exception {
        return this.find(Where.create(BaseEntity.buildEntityCond(this)), fields, null, dbLocker);
    }

    public IResultSet<Entity> find(Fields fields, Page page) throws Exception {
        return this.find(Where.create(BaseEntity.buildEntityCond(this)), fields, page, null);
    }

    public IResultSet<Entity> find(Fields fields, Page page, IDBLocker dbLocker) throws Exception {
        return this.find(Where.create(BaseEntity.buildEntityCond(this)), fields, page, dbLocker);
    }

    public IResultSet<Entity> find(Where where) throws Exception {
        return this.find(where, null, null, null);
    }

    public IResultSet<Entity> find(Where where, IDBLocker dbLocker) throws Exception {
        return this.find(where, null, null, dbLocker);
    }

    public IResultSet<Entity> find(Where where, Fields fields) throws Exception {
        return this.find(where, fields, null, null);
    }

    public IResultSet<Entity> find(Where where, Fields fields, IDBLocker dbLocker) throws Exception {
        return this.find(where, fields, null, dbLocker);
    }

    public IResultSet<Entity> find(Where where, Fields fields, Page page) throws Exception {
        return this.find(where, fields, page, null);
    }

    public IResultSet<Entity> find(Where where, Page page) throws Exception {
        return this.find(where, null, page, null);
    }

    public IResultSet<Entity> find(Where where, Page page, IDBLocker dbLocker) throws Exception {
        return this.find(where, null, page, dbLocker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IResultSet<Entity> find(Where where, Fields fields, Page page, IDBLocker dbLocker) throws Exception {
        DefaultSession _session = new DefaultSession(this.__doGetConnectionHolderSafed());
        try {
            EntitySQL<Entity> _entitySQL = EntitySQL.create(this.getEntityClass());
            if (fields != null) {
                _entitySQL.field(fields);
            }
            if (dbLocker != null) {
                _entitySQL.forUpdate(dbLocker);
            }
            IResultSet<Entity> iResultSet = _session.find(_entitySQL, where, page, this.getShardingable());
            return iResultSet;
        }
        finally {
            _session.close();
        }
    }

    public IResultSet<Entity> findAll() throws Exception {
        return this.find(null, null, null, null);
    }

    public IResultSet<Entity> findAll(Fields fields, Page page) throws Exception {
        return this.find(null, fields, page, null);
    }

    public IResultSet<Entity> findAll(Fields fields) throws Exception {
        return this.find(null, fields, null, null);
    }

    public IResultSet<Entity> findAll(Page page) throws Exception {
        return this.find(null, null, page, null);
    }

    public Entity findFirst() throws Exception {
        return this.findFirst(Where.create(BaseEntity.buildEntityCond(this)), null, null);
    }

    public Entity findFirst(IDBLocker dbLocker) throws Exception {
        return this.findFirst(Where.create(BaseEntity.buildEntityCond(this)), null, dbLocker);
    }

    public Entity findFirst(Fields fields) throws Exception {
        return this.findFirst(Where.create(BaseEntity.buildEntityCond(this)), fields, null);
    }

    public Entity findFirst(Fields fields, IDBLocker dbLocker) throws Exception {
        return this.findFirst(Where.create(BaseEntity.buildEntityCond(this)), fields, dbLocker);
    }

    public Entity findFirst(Where where) throws Exception {
        return this.findFirst(where, null, null);
    }

    public Entity findFirst(Where where, IDBLocker dbLocker) throws Exception {
        return this.findFirst(where, null, dbLocker);
    }

    public Entity findFirst(Where where, Fields fields) throws Exception {
        return this.findFirst(where, fields, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entity findFirst(Where where, Fields fields, IDBLocker dbLocker) throws Exception {
        DefaultSession _session = new DefaultSession(this.__doGetConnectionHolderSafed());
        try {
            EntitySQL<Entity> _entitySQL = EntitySQL.create(this.getEntityClass());
            if (fields != null) {
                _entitySQL.field(fields);
            }
            if (dbLocker != null) {
                _entitySQL.forUpdate(dbLocker);
            }
            Entity Entity = _session.findFirst(_entitySQL, where, this.getShardingable());
            return Entity;
        }
        finally {
            _session.close();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseEntity that = (BaseEntity)o;
        return this.getId() != null ? this.getId().equals(that.getId()) : that.getId() == null;
    }

    public int hashCode() {
        return this.getId() != null ? this.getId().hashCode() : 0;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.DEFAULT_STYLE);
    }

    public static <T extends IEntity> Cond buildEntityCond(T entity) throws Exception {
        return BaseEntity.buildEntityCond(entity, false);
    }

    public static <T extends IEntity> Cond buildEntityCond(T entity, boolean or) throws Exception {
        Cond _cond = Cond.create();
        EntityMeta _meta = EntityMeta.createAndGet(entity.getClass());
        ClassUtils.BeanWrapper _beanWrapper = ClassUtils.wrapper(entity);
        boolean _flag = false;
        for (String _field : _meta.getPropertyNames()) {
            Object _value = _meta.isMultiplePrimaryKey() && _meta.isPrimaryKey(_field) ? _meta.getPropertyByName(_field).getField().get(entity.getId()) : _beanWrapper.getValue(_meta.getPropertyByName(_field).getField().getName());
            if (_value == null) continue;
            if (_flag) {
                if (or) {
                    _cond.or();
                } else {
                    _cond.and();
                }
            } else {
                _flag = true;
            }
            _cond.eq(_field).param(_value);
        }
        return _cond;
    }
}

