/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.platform.persistence.jdbc.scaffold;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.ymate.platform.core.util.RuntimeUtils;
import net.ymate.platform.persistence.jdbc.IConnectionHolder;
import net.ymate.platform.persistence.jdbc.IDatabase;
import net.ymate.platform.persistence.jdbc.ISession;
import net.ymate.platform.persistence.jdbc.ISessionExecutor;
import net.ymate.platform.persistence.jdbc.base.IResultSetHandler;
import net.ymate.platform.persistence.jdbc.query.SQL;
import net.ymate.platform.persistence.jdbc.scaffold.ColumnInfo;
import net.ymate.platform.persistence.jdbc.scaffold.ConfigInfo;
import net.ymate.platform.persistence.jdbc.support.ResultSetHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TableInfo {
    private static final Log _LOG = LogFactory.getLog(TableInfo.class);
    private final String catalog;
    private final String schema;
    private final String name;
    private final List<String> pkSet;
    private final Map<String, ColumnInfo> fieldMap;

    public static List<String> getTableNames(IDatabase database) throws Exception {
        return database.openSession(new ISessionExecutor<List<String>>(){

            @Override
            public List<String> execute(ISession session) throws Exception {
                String _dbType = session.getConnectionHolder().getDialect().getName();
                String _sql = null;
                if ("mysql".equalsIgnoreCase(_dbType)) {
                    _sql = "show full tables where Table_type='BASE TABLE'";
                } else if ("oracle".equalsIgnoreCase(_dbType)) {
                    _sql = "select t.table_name from user_tables t";
                } else if ("sqlserver".equalsIgnoreCase(_dbType)) {
                    _sql = "select name from sysobjects where xtype='U'";
                } else {
                    throw new Error("The current database \"" + _dbType + "\" type not supported");
                }
                final ArrayList<String> _results = new ArrayList<String>();
                ResultSetHelper _helper = ResultSetHelper.bind(session.find(SQL.create(_sql), IResultSetHandler.ARRAY));
                if (_helper != null) {
                    _helper.forEach(new ResultSetHelper.ItemHandler(){

                        @Override
                        public boolean handle(ResultSetHelper.ItemWrapper wrapper, int row) throws Exception {
                            _results.add(wrapper.getAsString(0));
                            return true;
                        }
                    });
                }
                return _results;
            }
        });
    }

    public static List<String> getViewNames(IDatabase database) throws Exception {
        return database.openSession(new ISessionExecutor<List<String>>(){

            @Override
            public List<String> execute(ISession session) throws Exception {
                String _dbType = session.getConnectionHolder().getDialect().getName();
                String _sql = null;
                if ("mysql".equalsIgnoreCase(_dbType)) {
                    _sql = "show full tables where Table_type='VIEW'";
                } else if ("oracle".equalsIgnoreCase(_dbType)) {
                    _sql = "select view_name from user_views";
                } else if ("sqlserver".equalsIgnoreCase(_dbType)) {
                    _sql = "select name from sysobjects where xtype='V'";
                } else {
                    throw new Error("The current database \"" + _dbType + "\" type not supported");
                }
                final ArrayList<String> _results = new ArrayList<String>();
                ResultSetHelper _helper = ResultSetHelper.bind(session.find(SQL.create(_sql), IResultSetHandler.ARRAY));
                if (_helper != null) {
                    _helper.forEach(new ResultSetHelper.ItemHandler(){

                        @Override
                        public boolean handle(ResultSetHelper.ItemWrapper wrapper, int row) throws Exception {
                            _results.add(wrapper.getAsString(0));
                            return true;
                        }
                    });
                }
                return _results;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableInfo create(IConnectionHolder connectionHolder, ConfigInfo configInfo, String tableName, boolean view) throws Exception {
        DatabaseMetaData _databaseMetaData = connectionHolder.getConnection().getMetaData();
        Statement _statement = null;
        LinkedList<String> _primaryKeys = new LinkedList<String>();
        try {
            ResultSet _resultSet;
            if (!view) {
                _resultSet = _databaseMetaData.getPrimaryKeys(configInfo.getDbName(), "oracle".equalsIgnoreCase(connectionHolder.getDialect().getName()) ? configInfo.getDbUserName().toUpperCase() : configInfo.getDbUserName(), tableName);
                if (_resultSet == null) {
                    System.err.println("Database table \"" + tableName + "\" primaryKey resultSet is null, ignored");
                    TableInfo tableInfo = null;
                    return tableInfo;
                }
                while (_resultSet.next()) {
                    _primaryKeys.add(_resultSet.getString(4).toLowerCase());
                }
                if (_primaryKeys.isEmpty()) {
                    System.err.println("Database table \"" + tableName + "\" does not set the primary key, ignored");
                    TableInfo tableInfo = null;
                    return tableInfo;
                }
            }
            _statement = connectionHolder.getConnection().createStatement(1005, 1008);
            _resultSet = _statement.executeQuery("SELECT * FROM ".concat(connectionHolder.getDialect().wrapIdentifierQuote(tableName)));
            TableInfo tableInfo = new TableInfo(configInfo.getDbName(), configInfo.getDbUserName(), tableName, _primaryKeys, ColumnInfo.create(configInfo, connectionHolder.getDialect().getName(), tableName, _primaryKeys, _databaseMetaData, _resultSet.getMetaData()));
            return tableInfo;
        }
        finally {
            if (_statement != null) {
                try {
                    _statement.close();
                }
                catch (SQLException e) {
                    _LOG.warn((Object)"", RuntimeUtils.unwrapThrow((Throwable)e));
                }
            }
        }
    }

    public TableInfo(String catalog, String schema, String name, List<String> pkSet, Map<String, ColumnInfo> fieldMap) {
        this.catalog = catalog;
        this.schema = schema;
        this.name = name;
        this.pkSet = pkSet;
        this.fieldMap = fieldMap;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getPkSet() {
        return this.pkSet;
    }

    public Map<String, ColumnInfo> getFieldMap() {
        return this.fieldMap;
    }
}

