/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.platform.persistence.jdbc.scaffold;

import net.ymate.platform.core.util.ClassUtils;

public class Attr {
    private String varType;
    private String varName;
    private String columnName;
    private boolean autoIncrement;
    private boolean signed;
    private final int precision;
    private final int scale;
    private final boolean nullable;
    private final String defaultValue;
    private final String remarks;
    private boolean readonly;

    public Attr(String varType, String varName, String columnName, boolean autoIncrement, boolean signed, int precision, int scale, boolean nullable, String defaultValue, String remarks) {
        this.varName = varName;
        this.varType = varType;
        this.columnName = columnName;
        this.autoIncrement = autoIncrement;
        this.signed = signed;
        try {
            if (!signed && !ClassUtils.isSubclassOf(Class.forName(varType), Number.class)) {
                this.signed = true;
            }
        }
        catch (Exception ignored) {
            // empty catch block
        }
        this.precision = precision;
        this.scale = scale;
        this.nullable = nullable;
        this.defaultValue = defaultValue;
        this.remarks = remarks;
    }

    public String getVarType() {
        return this.varType;
    }

    public String getVarName() {
        return this.varName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public String toString() {
        return this.getVarName();
    }
}

