/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.platform.persistence.jdbc.repo;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.ymate.platform.configuration.IConfiguration;
import net.ymate.platform.core.beans.annotation.Order;
import net.ymate.platform.core.beans.annotation.Proxy;
import net.ymate.platform.core.beans.proxy.IProxy;
import net.ymate.platform.core.beans.proxy.IProxyChain;
import net.ymate.platform.core.util.ClassUtils;
import net.ymate.platform.core.util.ExpressionUtils;
import net.ymate.platform.core.util.RuntimeUtils;
import net.ymate.platform.persistence.IResultSet;
import net.ymate.platform.persistence.Params;
import net.ymate.platform.persistence.jdbc.IDatabase;
import net.ymate.platform.persistence.jdbc.ISession;
import net.ymate.platform.persistence.jdbc.JDBC;
import net.ymate.platform.persistence.jdbc.base.IResultSetHandler;
import net.ymate.platform.persistence.jdbc.query.SQL;
import net.ymate.platform.persistence.jdbc.repo.IRepoScriptProcessor;
import net.ymate.platform.persistence.jdbc.repo.IRepository;
import net.ymate.platform.persistence.jdbc.repo.annotation.Repository;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Proxy(annotation={Repository.class}, order=@Order(value=888))
public class RepoProxy
implements IProxy {
    private static final Log _LOG = LogFactory.getLog(RepoProxy.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doProxy(IProxyChain proxyChain) throws Throwable {
        Repository _repo = proxyChain.getTargetMethod().getAnnotation(Repository.class);
        if (_repo == null) {
            return proxyChain.doProxyChain();
        }
        IDatabase _db = JDBC.get(proxyChain.getProxyFactory().getOwner());
        ISession _session = null;
        try {
            Repository _superRepo;
            _session = StringUtils.isNotBlank((String)_repo.dsName()) ? _db.openSession(_repo.dsName()) : (StringUtils.isNotBlank((String)(_superRepo = proxyChain.getTargetClass().getAnnotation(Repository.class)).dsName()) ? _db.openSession(_superRepo.dsName()) : _db.openSession());
            IRepoScriptProcessor _processor = null;
            String _targetSQL = _repo.value();
            if (StringUtils.isBlank((String)_targetSQL)) {
                try {
                    IConfiguration _conf = ((IRepository)proxyChain.getTargetObject()).getConfig();
                    String _keyStr = StringUtils.lowerCase((String)(_repo.item() + "_" + _session.getConnectionHolder().getDialect().getName()));
                    Map _statementMap = _conf.getMap(_keyStr);
                    if (_statementMap == null || _statementMap.isEmpty()) {
                        _keyStr = StringUtils.lowerCase((String)_repo.item());
                        _statementMap = _conf.getMap(_keyStr);
                    }
                    if (_statementMap == null || _statementMap.isEmpty()) {
                        throw new NullArgumentException(_keyStr);
                    }
                    _targetSQL = _conf.getString(_keyStr);
                    String _targetType = StringUtils.trimToNull((String)((String)_statementMap.get("language")));
                    if (StringUtils.isNotBlank((String)_targetType) && (_processor = IRepoScriptProcessor.Manager.getScriptProcessor(_targetType)) != null) {
                        _processor.init(_targetSQL);
                        _targetSQL = _processor.process(_repo.item(), proxyChain.getMethodParams());
                    }
                }
                catch (Exception e) {
                    _LOG.warn((Object)"", RuntimeUtils.unwrapThrow((Throwable)e));
                }
            }
            if (StringUtils.isNotBlank((String)_targetSQL)) {
                Object _result;
                switch (_repo.type()) {
                    case UPDATE: {
                        _result = Integer.valueOf(_session.executeForUpdate(this.__buildSQL(_targetSQL, proxyChain.getTargetMethod(), proxyChain.getMethodParams())));
                        break;
                    }
                    default: {
                        _result = _session.find(this.__buildSQL(_targetSQL, proxyChain.getTargetMethod(), proxyChain.getMethodParams()), IResultSetHandler.ARRAY);
                        if (_processor == null || !_processor.isFilterable()) break;
                        _result = _processor.doFilter(_result);
                    }
                }
                if (_repo.useFilter()) {
                    Class<?> _paramType;
                    int _position = proxyChain.getMethodParams().length - 1;
                    Object _lastParam = proxyChain.getMethodParams()[_position];
                    Class<?> clazz = _paramType = _lastParam != null ? proxyChain.getMethodParams()[_position].getClass() : null;
                    if (_paramType != null && _paramType.isArray()) {
                        if (_result != null) {
                            proxyChain.getMethodParams()[_position] = ArrayUtils.add((Object[])((Object[])proxyChain.getMethodParams()[_position]), _result);
                        }
                    } else {
                        proxyChain.getMethodParams()[_position] = _result;
                    }
                } else {
                    IResultSet<Object[]> iResultSet = _result;
                    return iResultSet;
                }
            }
            Object object = proxyChain.doProxyChain();
            return object;
        }
        finally {
            if (_session != null) {
                _session.close();
            }
        }
    }

    private SQL __buildSQL(String targetSql, Method targetMethod, Object[] params) {
        HashMap<String, Object> _paramMap = new HashMap<String, Object>();
        String[] _paramNames = ClassUtils.getMethodParamNames((Method)targetMethod);
        if (_paramNames != null && _paramNames.length > 0) {
            for (int _idx = 0; _idx < _paramNames.length - 1; ++_idx) {
                _paramMap.put(_paramNames[_idx], params[_idx]);
            }
            if (!_paramMap.isEmpty()) {
                ExpressionUtils _exp = ExpressionUtils.bind((String)targetSql);
                Params _paramValues = Params.create((Object[])new Object[0]);
                for (String _paramName : _exp.getVariables()) {
                    _exp.set(_paramName, "?");
                    _paramValues.add(_paramMap.get(_paramName));
                }
                return SQL.create(_exp.getResult()).param(_paramValues);
            }
        }
        return SQL.create(targetSql);
    }
}

