/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.platform.persistence.jdbc.repo;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.ymate.platform.persistence.jdbc.repo.impl.DefaultRepoScriptProcessor;
import org.apache.commons.lang.StringUtils;

public interface IRepoScriptProcessor {
    public String getName();

    public void init(String var1) throws Exception;

    public String process(String var1, Object ... var2) throws Exception;

    public boolean isFilterable();

    public Object doFilter(Object var1);

    public static class Manager {
        private static final Map<String, Class<? extends IRepoScriptProcessor>> __scriptProcessors = new ConcurrentHashMap<String, Class<? extends IRepoScriptProcessor>>();

        public static void registerScriptProcessor(String name, Class<? extends IRepoScriptProcessor> targetClass) {
            String _key = StringUtils.defaultIfBlank((String)name, (String)targetClass.getName()).toLowerCase();
            if (!__scriptProcessors.containsKey(_key)) {
                __scriptProcessors.put(_key, targetClass);
            }
        }

        public static IRepoScriptProcessor getScriptProcessor(String name) throws Exception {
            if (StringUtils.isNotBlank((String)name) && __scriptProcessors.containsKey(name.toLowerCase())) {
                return __scriptProcessors.get(name.toLowerCase()).newInstance();
            }
            return null;
        }

        static {
            Manager.registerScriptProcessor("JavaScript".toLowerCase(), DefaultRepoScriptProcessor.class);
        }
    }
}

