/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.platform.persistence.jdbc.query;

import net.ymate.platform.persistence.Fields;
import net.ymate.platform.persistence.Params;
import net.ymate.platform.persistence.jdbc.query.Cond;
import net.ymate.platform.persistence.jdbc.query.GroupBy;
import net.ymate.platform.persistence.jdbc.query.OrderBy;
import org.apache.commons.lang.StringUtils;

public final class Where {
    private Cond __cond;
    private GroupBy __groupBy;
    private OrderBy __orderBy = OrderBy.create();

    public static Where create() {
        return new Where();
    }

    public static Where create(String whereCond) {
        return new Where(whereCond);
    }

    public static Where create(Cond cond) {
        return new Where(cond);
    }

    private Where() {
        this.__cond = Cond.create();
    }

    private Where(String whereCond) {
        this();
        this.__cond.cond(whereCond);
    }

    private Where(Cond cond) {
        this.__cond = cond;
    }

    public Where where(Where where) {
        this.__cond.cond(where.cond());
        this.__orderBy.orderBy(where.orderBy());
        if (where.groupBy() != null) {
            if (this.__groupBy != null) {
                this.__groupBy.fields().add(where.groupBy().fields());
                this.__groupBy.having().cond(where.groupBy().having());
            } else {
                this.__groupBy = where.groupBy();
            }
        }
        return this;
    }

    public Cond cond() {
        return this.__cond;
    }

    public GroupBy groupBy() {
        return this.__groupBy;
    }

    public OrderBy orderBy() {
        return this.__orderBy;
    }

    public Params getParams() {
        Params _p = Params.create((Object[])new Object[0]).add(this.__cond.params());
        if (this.__groupBy != null && this.__groupBy.having() != null) {
            _p.add(this.__groupBy.having().params());
        }
        return _p;
    }

    public String toSQL() {
        StringBuilder _whereSB = new StringBuilder("");
        if (this.__cond != null && StringUtils.isNotBlank((String)this.__cond.toString())) {
            _whereSB.append("WHERE ").append(this.__cond.toString());
        }
        if (this.__groupBy != null) {
            _whereSB.append(" ").append(this.__groupBy);
        }
        return _whereSB.toString();
    }

    public Where param(Object param) {
        this.__cond.param(param);
        return this;
    }

    public Where param(Params params) {
        this.__cond.param(params);
        return this;
    }

    public Where groupBy(String field) {
        this.groupBy(Fields.create((String[])new String[0]).add(field));
        return this;
    }

    public Where groupBy(Fields fields) {
        this.__groupBy = GroupBy.create(fields);
        return this;
    }

    public Where groupBy(String prefix, String field) {
        this.__groupBy = GroupBy.create(prefix, field);
        return this;
    }

    public Where groupBy(GroupBy groupBy) {
        this.__groupBy = groupBy;
        return this;
    }

    public Where having(Cond cond) {
        this.__groupBy.having(cond);
        return this;
    }

    public Where orderAsc(String field) {
        this.__orderBy.asc(field);
        return this;
    }

    public Where orderAsc(String prefix, String field) {
        this.__orderBy.asc(prefix, field);
        return this;
    }

    public Where orderDesc(String field) {
        this.__orderBy.desc(field);
        return this;
    }

    public Where orderDesc(String prefix, String field) {
        this.__orderBy.desc(prefix, field);
        return this;
    }

    public String toString() {
        return this.toSQL() + " " + this.__orderBy;
    }
}

