/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.platform.persistence.jdbc.query;

public interface IDBLocker {
    public static final IDBLocker DEFAULT;
    @Deprecated
    public static final IDBLocker MYSQL;
    @Deprecated
    public static final IDBLocker ORACLE;
    public static final IDBLocker ORACLE_NOWAIT;
    public static final IDBLocker SQLSERVER_NOLOCK;
    public static final IDBLocker SQLSERVER_HOLDLOCK;
    public static final IDBLocker SQLSERVER_UPDLOCK;
    public static final IDBLocker SQLSERVER_TABLOCK;
    public static final IDBLocker SQLSERVER_PAGLOCK;
    public static final IDBLocker SQLSERVER_TABLOCKX;

    public String toSQL();

    static {
        MYSQL = DEFAULT = new IDBLocker(){

            @Override
            public String toSQL() {
                return " FOR UPDATE";
            }
        };
        ORACLE = DEFAULT;
        ORACLE_NOWAIT = new IDBLocker(){

            @Override
            public String toSQL() {
                return "FOR UPDATE NOWAIT";
            }
        };
        SQLSERVER_NOLOCK = new SQLServerLocker(SQLServerLocker.LockType.NOLOCK);
        SQLSERVER_HOLDLOCK = new SQLServerLocker(SQLServerLocker.LockType.HOLDLOCK);
        SQLSERVER_UPDLOCK = new SQLServerLocker(SQLServerLocker.LockType.UPDLOCK);
        SQLSERVER_TABLOCK = new SQLServerLocker(SQLServerLocker.LockType.TABLOCK);
        SQLSERVER_PAGLOCK = new SQLServerLocker(SQLServerLocker.LockType.PAGLOCK);
        SQLSERVER_TABLOCKX = new SQLServerLocker(SQLServerLocker.LockType.TABLOCKX);
    }

    public static class SQLServerLocker
    implements IDBLocker {
        private final LockType __lockType;

        SQLServerLocker(LockType lockType) {
            this.__lockType = lockType;
        }

        @Override
        public String toSQL() {
            return "WITH (" + this.__lockType.name() + ")";
        }

        static enum LockType {
            NOLOCK,
            HOLDLOCK,
            UPDLOCK,
            TABLOCK,
            PAGLOCK,
            TABLOCKX;

        }
    }
}

