/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.platform.persistence.jdbc.query;

import net.ymate.platform.persistence.Fields;
import net.ymate.platform.persistence.IFunction;
import net.ymate.platform.persistence.Params;
import net.ymate.platform.persistence.jdbc.query.Query;
import net.ymate.platform.persistence.jdbc.query.SQL;
import net.ymate.platform.persistence.jdbc.query.Select;
import org.apache.commons.lang.StringUtils;

public final class Cond
extends Query<Cond> {
    private final StringBuilder __condSB = new StringBuilder();
    private final Params __params = Params.create((Object[])new Object[0]);

    public static Cond create() {
        return new Cond();
    }

    private Cond() {
    }

    public Params params() {
        return this.__params;
    }

    public Cond param(Object param) {
        this.__params.add(param);
        return this;
    }

    public Cond param(Params params) {
        this.__params.add(params);
        return this;
    }

    public Cond cond(String cond) {
        this.__condSB.append(" ").append(cond).append(" ");
        return this;
    }

    public Cond cond(IFunction func) {
        return this.cond(func.build());
    }

    public Cond cond(Cond cond) {
        this.__condSB.append(cond.toString());
        this.__params.add(cond.params());
        return this;
    }

    public Cond opt(String prefixA, String fieldA, OPT opt, String prefixB, String fieldB) {
        return this.opt(Fields.field((String)prefixA, (String)this.__wrapIdentifierField(fieldA)), opt, Fields.field((String)prefixB, (String)this.__wrapIdentifierField(fieldB)));
    }

    public Cond opt(String fieldA, OPT opt, String fieldB) {
        this.__condSB.append(fieldA).append(" ").append((Object)opt).append(" ").append(fieldB);
        return this;
    }

    public Cond optWrap(String fieldA, OPT opt, String fieldB) {
        return this.opt(this.__wrapIdentifierField(fieldA), opt, this.__wrapIdentifierField(fieldB));
    }

    public Cond opt(String prefix, String field, OPT opt) {
        return this.opt(Fields.field((String)prefix, (String)this.__wrapIdentifierField(field)), opt);
    }

    public Cond opt(String field, OPT opt) {
        this.__condSB.append(field).append(" ").append((Object)opt).append(" ?");
        return this;
    }

    public Cond optWrap(String field, OPT opt) {
        return this.opt(this.__wrapIdentifierField(field), opt);
    }

    public Cond opt(IFunction func, OPT opt) {
        return this.opt(func.build(), opt);
    }

    public Cond eqOne() {
        this.__condSB.append("1 = 1");
        return this;
    }

    public Cond eq(String prefix, String field) {
        return this.eq(Fields.field((String)prefix, (String)this.__wrapIdentifierField(field)));
    }

    public Cond eq(String field) {
        return this.opt(field, OPT.EQ);
    }

    public Cond eqWrap(String field) {
        return this.optWrap(field, OPT.EQ);
    }

    public Cond eq(IFunction func) {
        return this.opt(func, OPT.EQ);
    }

    public Cond notEq(String prefix, String field) {
        return this.notEq(Fields.field((String)prefix, (String)this.__wrapIdentifierField(field)));
    }

    public Cond notEq(String field) {
        return this.opt(field, OPT.NOT_EQ);
    }

    public Cond notEqWrap(String field) {
        return this.optWrap(field, OPT.NOT_EQ);
    }

    public Cond notEq(IFunction func) {
        return this.opt(func, OPT.NOT_EQ);
    }

    public Cond gtEq(String prefix, String field) {
        return this.gtEq(Fields.field((String)prefix, (String)this.__wrapIdentifierField(field)));
    }

    public Cond gtEq(String field) {
        return this.opt(field, OPT.GT_EQ);
    }

    public Cond gtEqWrap(String field) {
        return this.optWrap(field, OPT.GT_EQ);
    }

    public Cond gtEq(IFunction func) {
        return this.opt(func, OPT.GT_EQ);
    }

    public Cond gt(String prefix, String field) {
        return this.gt(Fields.field((String)prefix, (String)this.__wrapIdentifierField(field)));
    }

    public Cond gt(String field) {
        return this.opt(field, OPT.GT);
    }

    public Cond gtWrap(String field) {
        return this.optWrap(field, OPT.GT);
    }

    public Cond gt(IFunction func) {
        return this.opt(func, OPT.GT);
    }

    public Cond ltEq(String prefix, String field) {
        return this.ltEq(Fields.field((String)prefix, (String)this.__wrapIdentifierField(field)));
    }

    public Cond ltEq(String field) {
        return this.opt(field, OPT.LT_EQ);
    }

    public Cond ltEqWrap(String field) {
        return this.optWrap(field, OPT.LT_EQ);
    }

    public Cond ltEq(IFunction func) {
        return this.opt(func, OPT.LT_EQ);
    }

    public Cond lt(String prefix, String field) {
        return this.lt(Fields.field((String)prefix, (String)this.__wrapIdentifierField(field)));
    }

    public Cond lt(String field) {
        return this.opt(field, OPT.LT);
    }

    public Cond ltWrap(String field) {
        return this.optWrap(field, OPT.LT);
    }

    public Cond lt(IFunction func) {
        return this.opt(func, OPT.LT);
    }

    public Cond like(String prefix, String field) {
        return this.like(Fields.field((String)prefix, (String)this.__wrapIdentifierField(field)));
    }

    public Cond like(String field) {
        return this.opt(field, OPT.LIKE);
    }

    public Cond likeWrap(String field) {
        return this.optWrap(field, OPT.LIKE);
    }

    public Cond like(IFunction func) {
        return this.opt(func, OPT.LIKE);
    }

    public Cond between(String prefix, String field, Object valueOne, Object valueTwo) {
        return this.between(Fields.field((String)prefix, (String)this.__wrapIdentifierField(field)), valueOne, valueTwo);
    }

    public Cond between(String field, Object valueOne, Object valueTwo) {
        this.__condSB.append(field).append(" BETWEEN ? AND ?");
        this.__params.add(valueOne).add(valueTwo);
        return this;
    }

    public Cond betweenWrap(String field, Object valueOne, Object valueTwo) {
        return this.between(null, field, valueOne, valueTwo);
    }

    public Cond between(IFunction func, Object valueOne, Object valueTwo) {
        return this.between(func.build(), valueOne, valueTwo);
    }

    public Cond isNull(String prefix, String field) {
        return this.isNull(Fields.field((String)prefix, (String)this.__wrapIdentifierField(field)));
    }

    public Cond isNull(String field) {
        this.__condSB.append(field).append(" IS NULL");
        return this;
    }

    public Cond isNullWrap(String field) {
        return this.isNull(null, field);
    }

    public Cond isNull(IFunction func) {
        return this.isNull(func.build());
    }

    public Cond isNotNull(String prefix, String field) {
        return this.isNotNull(Fields.field((String)prefix, (String)this.__wrapIdentifierField(field)));
    }

    public Cond isNotNull(String field) {
        this.__condSB.append(field).append(" IS NOT NULL");
        return this;
    }

    public Cond isNotNullWrap(String field) {
        return this.isNotNull(null, field);
    }

    public Cond isNotNull(IFunction func) {
        return this.isNotNull(func.build());
    }

    public Cond and() {
        return this.cond("AND");
    }

    public Cond or() {
        return this.cond("OR");
    }

    public Cond not() {
        return this.cond("NOT");
    }

    public Cond bracketBegin() {
        return this.cond("(");
    }

    public Cond bracketEnd() {
        return this.cond(")");
    }

    public Cond exists(SQL subSql) {
        this.__condSB.append(" EXISTS (").append(subSql.getSQL()).append(")");
        this.__params.add(subSql.params());
        return this;
    }

    public Cond exists(Select subSql) {
        this.__condSB.append(" EXISTS (").append(subSql.toString()).append(")");
        this.__params.add(subSql.getParams());
        return this;
    }

    public Cond in(String prefix, String field, SQL subSql) {
        return this.in(Fields.field((String)prefix, (String)this.__wrapIdentifierField(field)), subSql);
    }

    public Cond in(String field, SQL subSql) {
        this.__condSB.append(field).append(" IN (").append(subSql.getSQL()).append(")");
        this.__params.add(subSql.params());
        return this;
    }

    public Cond inWrap(String field, SQL subSql) {
        return this.in(null, field, subSql);
    }

    public Cond in(String prefix, String field, Select subSql) {
        return this.in(Fields.field((String)prefix, (String)this.__wrapIdentifierField(field)), subSql);
    }

    public Cond in(String field, Select subSql) {
        this.__condSB.append(field).append(" IN (").append(subSql.toString()).append(")");
        this.__params.add(subSql.getParams());
        return this;
    }

    public Cond inWrap(String field, Select subSql) {
        return this.in(null, field, subSql);
    }

    public Cond in(String prefix, String field, Params params) {
        return this.in(Fields.field((String)prefix, (String)this.__wrapIdentifierField(field)), params);
    }

    public Cond in(String field, Params params) {
        this.__condSB.append(field).append(" IN (").append(StringUtils.repeat((String)"?", (String)", ", (int)params.params().size())).append(")");
        this.__params.add(params);
        return this;
    }

    public Cond inWrap(String field, Params params) {
        return this.in(null, field, params);
    }

    public Cond expr(boolean expression, Cond cond) {
        if (expression && cond != null) {
            this.cond(cond);
        }
        return this;
    }

    public Cond expr(boolean expression, String cond) {
        if (expression && cond != null) {
            this.cond(cond);
        }
        return this;
    }

    public Cond exprNotEmpty(Object target, Cond cond) {
        if (target != null && cond != null) {
            boolean _flag = true;
            if (target.getClass().isArray()) {
                _flag = ((Object[])target).length > 0;
            } else if (target instanceof String) {
                _flag = StringUtils.isNotBlank((String)((String)target));
            }
            if (_flag) {
                this.cond(cond);
            }
        }
        return this;
    }

    public String toString() {
        return this.__condSB.toString();
    }

    public static enum OPT {
        EQ("="),
        NOT_EQ("!="),
        LT("<"),
        GT(">"),
        LT_EQ("<="),
        GT_EQ(">="),
        LIKE("LIKE");

        private final String __opt;

        private OPT(String opt) {
            this.__opt = opt;
        }

        public String toString() {
            return this.__opt;
        }
    }
}

