/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.platform.persistence.jdbc.dialect;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.ymate.platform.core.util.ClassUtils;
import net.ymate.platform.core.util.ExpressionUtils;
import net.ymate.platform.persistence.Fields;
import net.ymate.platform.persistence.IShardingRule;
import net.ymate.platform.persistence.IShardingable;
import net.ymate.platform.persistence.base.EntityMeta;
import net.ymate.platform.persistence.base.IEntity;
import net.ymate.platform.persistence.jdbc.dialect.IDialect;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractDialect
implements IDialect {
    protected static final String __LINE_END_FLAG = ",\n";
    private String identifierQuoteBegin = "";
    private String identifierQuoteEnd = "";

    public AbstractDialect() {
    }

    public AbstractDialect(String identifierQuoteBegin, String identifierQuoteEnd) {
        this.setIdentifierQuote(identifierQuoteBegin, identifierQuoteEnd);
    }

    @Override
    public String wrapIdentifierQuote(String origin) {
        return this.identifierQuoteBegin.concat(origin).concat(this.identifierQuoteEnd);
    }

    @Override
    public void setIdentifierQuote(String identifierQuoteBegin, String identifierQuoteEnd) {
        this.identifierQuoteBegin = StringUtils.trimToEmpty((String)identifierQuoteBegin);
        this.identifierQuoteEnd = StringUtils.trimToEmpty((String)identifierQuoteEnd);
    }

    @Override
    public String getIdentifierQuoteBegin() {
        return this.identifierQuoteBegin;
    }

    @Override
    public String getIdentifierQuoteEnd() {
        return this.identifierQuoteEnd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getGeneratedKey(Statement statement, List<String> autoincrementKeys) throws SQLException {
        HashMap<String, Object> _ids = new HashMap<String, Object>();
        ResultSet _keyRSet = statement.getGeneratedKeys();
        try {
            for (String _autoKey : autoincrementKeys) {
                while (_keyRSet.next()) {
                    Object _keyValue;
                    try {
                        _keyValue = _keyRSet.getObject(_autoKey);
                    }
                    catch (SQLException e) {
                        _keyValue = _keyRSet.getObject(1);
                    }
                    _ids.put(_autoKey, _keyValue);
                }
            }
        }
        finally {
            _keyRSet.close();
        }
        return _ids;
    }

    @Override
    public String getSequenceNextValSql(String sequenceName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String buildPagedQuerySQL(String originSql, int page, int pageSize) {
        int _limit = (page - 1) * pageSize;
        if (pageSize == 0) {
            return originSql.concat(" limit ").concat(Integer.toString(_limit));
        }
        return originSql.concat(" limit ").concat(Integer.toString(_limit)).concat(", ").concat(Integer.toString(pageSize));
    }

    @Override
    public String buildCreateSQL(Class<? extends IEntity> entityClass, String prefix, IShardingable shardingable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String buildDropSQL(Class<? extends IEntity> entityClass, String prefix, IShardingable shardingable) {
        throw new UnsupportedOperationException();
    }

    protected String __doGetColumnType(Class<?> clazz) {
        String _columnType = "VARCHAR";
        if (BigDecimal.class.equals(clazz)) {
            _columnType = "NUMERIC";
        } else if (Boolean.class.equals(clazz) || Boolean.TYPE.equals(clazz)) {
            _columnType = "BIT";
        } else if (Byte.class.equals(clazz) || Byte.TYPE.equals(clazz)) {
            _columnType = "TINYINT";
        } else if (Short.class.equals(clazz) || Short.TYPE.equals(clazz)) {
            _columnType = "SMALLINT";
        } else if (Integer.class.equals(clazz) || Integer.TYPE.equals(clazz)) {
            _columnType = "INTEGER";
        } else if (Long.class.equals(clazz) || Long.TYPE.equals(clazz)) {
            _columnType = "BIGINT";
        } else if (Float.class.equals(clazz) || Float.TYPE.equals(clazz)) {
            _columnType = "FLOAT";
        } else if (Double.class.equals(clazz) || Double.TYPE.equals(clazz)) {
            _columnType = "DOUBLE";
        } else if (byte[].class.equals(clazz) || Byte[].class.equals(clazz)) {
            _columnType = "BINARY";
        } else if (Date.class.equals(clazz) || java.util.Date.class.equals(clazz)) {
            _columnType = "DATE";
        } else if (Time.class.equals(clazz)) {
            _columnType = "TIME";
        } else if (Timestamp.class.equals(clazz)) {
            _columnType = "TIMESTAMP";
        } else if (Blob.class.equals(clazz)) {
            _columnType = "BLOB";
        } else if (Clob.class.equals(clazz)) {
            _columnType = "CLOB";
        }
        return _columnType;
    }

    protected String __doGenerateFieldsFormatStr(Fields fields, String suffix, String separator) {
        StringBuilder _fieldsSB = new StringBuilder();
        Iterator _fieldsIt = fields.fields().iterator();
        suffix = StringUtils.defaultIfBlank((String)suffix, (String)"");
        separator = StringUtils.defaultIfBlank((String)separator, (String)", ");
        while (_fieldsIt.hasNext()) {
            _fieldsSB.append(this.wrapIdentifierQuote((String)_fieldsIt.next())).append(suffix);
            if (!_fieldsIt.hasNext()) continue;
            _fieldsSB.append(separator);
        }
        return _fieldsSB.toString();
    }

    @Override
    public String buildTableName(String prefix, EntityMeta entityMeta, IShardingable shardingable) {
        IShardingRule _rule;
        String _entityName = entityMeta.getEntityName();
        if (shardingable != null && entityMeta.getShardingRule() != null && (_rule = (IShardingRule)ClassUtils.impl((Class)entityMeta.getShardingRule().value(), IShardingRule.class)) != null) {
            _entityName = _rule.getShardName(entityMeta.getEntityName(), shardingable.getShardingParam());
        }
        return this.wrapIdentifierQuote(StringUtils.defaultIfBlank((String)prefix, (String)"").concat(_entityName));
    }

    protected void __doValidProperty(EntityMeta entityMeta, Fields fields, boolean isPrimaryKeys) {
        if (isPrimaryKeys) {
            for (String _pkField : fields.fields()) {
                if (entityMeta.isPrimaryKey(_pkField)) continue;
                throw new IllegalArgumentException("'".concat(_pkField).concat("' isn't primary key field"));
            }
        } else {
            for (String _field : fields.fields()) {
                if (entityMeta.containsProperty(_field)) continue;
                throw new IllegalArgumentException("'".concat(_field).concat("' isn't table field"));
            }
        }
    }

    @Override
    public String buildInsertSQL(Class<? extends IEntity> entityClass, String prefix, IShardingable shardingable, Fields fields) {
        EntityMeta _meta = EntityMeta.createAndGet(entityClass);
        ExpressionUtils _exp = ExpressionUtils.bind((String)"INSERT INTO ${table_name} (${fields}) VALUES (${values})").set("table_name", this.buildTableName(prefix, _meta, shardingable));
        Fields _fields = Fields.create((String[])new String[0]);
        if (fields == null || fields.fields().isEmpty()) {
            _fields.add(_meta.getPropertyNames());
        } else {
            _fields.add(fields);
            this.__doValidProperty(_meta, _fields, false);
        }
        return _exp.set("fields", this.__doGenerateFieldsFormatStr(_fields, null, null)).set("values", StringUtils.repeat((String)"?", (String)", ", (int)_fields.fields().size())).getResult();
    }

    @Override
    public String buildDeleteByPkSQL(Class<? extends IEntity> entityClass, String prefix, IShardingable shardingable, Fields pkFields) {
        EntityMeta _meta = EntityMeta.createAndGet(entityClass);
        ExpressionUtils _exp = ExpressionUtils.bind((String)"DELETE FROM ${table_name} WHERE ${pk}").set("table_name", this.buildTableName(prefix, _meta, shardingable));
        Fields _fields = Fields.create((String[])new String[0]);
        if (pkFields == null || pkFields.fields().isEmpty()) {
            _fields.add((Collection)_meta.getPrimaryKeys());
        } else {
            _fields.add(pkFields);
            this.__doValidProperty(_meta, _fields, true);
        }
        return _exp.set("pk", this.__doGenerateFieldsFormatStr(_fields, " = ?", " and ")).getResult();
    }

    @Override
    public String buildUpdateByPkSQL(Class<? extends IEntity> entityClass, String prefix, IShardingable shardingable, Fields pkFields, Fields fields) {
        EntityMeta _meta = EntityMeta.createAndGet(entityClass);
        ExpressionUtils _exp = ExpressionUtils.bind((String)"UPDATE ${table_name} SET ${fields} WHERE ${pk}").set("table_name", this.buildTableName(prefix, _meta, shardingable));
        Fields _fields = Fields.create((String[])new String[0]);
        for (String _field : fields == null || fields.fields().isEmpty() ? _meta.getPropertyNames() : fields.fields()) {
            if (_meta.containsProperty(_field)) {
                if (_meta.isPrimaryKey(_field)) continue;
                _fields.add(_field);
                continue;
            }
            throw new IllegalArgumentException("'".concat(_field).concat("' isn't table field"));
        }
        _exp.set("fields", this.__doGenerateFieldsFormatStr(_fields, " = ?", null));
        if (pkFields != null && !pkFields.fields().isEmpty()) {
            _fields = pkFields;
            this.__doValidProperty(_meta, _fields, true);
        } else {
            _fields = Fields.create((String[])new String[0]).add((Collection)_meta.getPrimaryKeys());
        }
        return _exp.set("pk", this.__doGenerateFieldsFormatStr(_fields, " = ?", " and ")).getResult();
    }

    @Override
    public String buildSelectByPkSQL(Class<? extends IEntity> entityClass, String prefix, IShardingable shardingable, Fields pkFields, Fields fields) {
        EntityMeta _meta = EntityMeta.createAndGet(entityClass);
        ExpressionUtils _exp = ExpressionUtils.bind((String)"SELECT ${fields} FROM ${table_name} WHERE ${pk}").set("table_name", this.buildTableName(prefix, _meta, shardingable));
        if (fields == null || fields.fields().isEmpty()) {
            fields = Fields.create((String[])new String[0]).add(_meta.getPropertyNames());
        } else {
            this.__doValidProperty(_meta, fields, false);
        }
        _exp.set("fields", this.__doGenerateFieldsFormatStr(fields, null, null));
        if (pkFields != null && !pkFields.fields().isEmpty()) {
            this.__doValidProperty(_meta, pkFields, true);
        } else {
            pkFields = Fields.create((String[])new String[0]).add((Collection)_meta.getPrimaryKeys());
        }
        return _exp.set("pk", this.__doGenerateFieldsFormatStr(pkFields, " = ?", " and ")).getResult();
    }

    @Override
    public String buildSelectSQL(Class<? extends IEntity> entityClass, String prefix, IShardingable shardingable, Fields fields) {
        EntityMeta _meta = EntityMeta.createAndGet(entityClass);
        ExpressionUtils _exp = ExpressionUtils.bind((String)"SELECT ${fields} FROM ${table_name}").set("table_name", this.buildTableName(prefix, _meta, shardingable));
        if (fields == null || fields.fields().isEmpty()) {
            fields = Fields.create((String[])new String[0]).add(_meta.getPropertyNames());
        } else {
            this.__doValidProperty(_meta, fields, false);
        }
        return _exp.set("fields", this.__doGenerateFieldsFormatStr(fields, null, null)).getResult();
    }
}

