/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.platform.persistence.jdbc.base.impl;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import net.ymate.platform.core.util.ExpressionUtils;
import net.ymate.platform.persistence.base.Type;
import net.ymate.platform.persistence.jdbc.IConnectionHolder;
import net.ymate.platform.persistence.jdbc.base.AbstractOperator;
import net.ymate.platform.persistence.jdbc.base.AccessorEventContext;
import net.ymate.platform.persistence.jdbc.base.IAccessorConfig;
import net.ymate.platform.persistence.jdbc.base.IProcedureOperator;
import net.ymate.platform.persistence.jdbc.base.IResultSetHandler;
import net.ymate.platform.persistence.jdbc.base.SQLParameter;
import net.ymate.platform.persistence.jdbc.base.impl.BaseAccessor;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.StopWatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultProcedureOperator<T>
extends AbstractOperator
implements IProcedureOperator<T> {
    private static final Log _LOG = LogFactory.getLog(DefaultProcedureOperator.class);
    private final List<Integer> __outParams = new ArrayList<Integer>();
    private IProcedureOperator.IOutResultProcessor __resultProcessor;
    private IResultSetHandler<T> __resultSetHandler;
    private final List<List<T>> __resultSets = new ArrayList<List<T>>();

    public DefaultProcedureOperator(String sql, IConnectionHolder connectionHolder) {
        super(sql, connectionHolder);
    }

    public DefaultProcedureOperator(String sql, IConnectionHolder connectionHolder, IAccessorConfig accessorConfig) {
        super(sql, connectionHolder, accessorConfig);
    }

    @Override
    public void execute() throws Exception {
        if (!this.executed) {
            StopWatch _time = new StopWatch();
            _time.start();
            try {
                this.__doExecute();
                this.executed = true;
            }
            finally {
                _time.stop();
                this.expenseTime = _time.getTime();
                if (this.getConnectionHolder().getDataSourceCfgMeta().isShowSQL()) {
                    _LOG.info((Object)ExpressionUtils.bind((String)"[${sql}]${param}[${count}][${time}]").set("sql", StringUtils.defaultIfBlank((String)this.sql, (String)"@NULL")).set("param", this.__doSerializeParameters()).set("count", "N/A").set("time", this.expenseTime + "ms").getResult());
                }
            }
        }
    }

    @Override
    public IProcedureOperator<T> execute(IResultSetHandler<T> resultSetHandler) throws Exception {
        this.__resultSetHandler = resultSetHandler;
        this.execute();
        return this;
    }

    @Override
    public IProcedureOperator<T> execute(IProcedureOperator.IOutResultProcessor resultProcessor) throws Exception {
        this.__resultProcessor = resultProcessor;
        this.execute();
        return this;
    }

    @Override
    protected int __doExecute() throws Exception {
        int n;
        Statement _statement = null;
        AccessorEventContext _context = null;
        boolean _hasEx = false;
        try {
            boolean _flag;
            BaseAccessor _accessor = new BaseAccessor(this.getAccessorConfig());
            _statement = _accessor.getCallableStatement(this.getConnectionHolder().getConnection(), this.__doBuildCallSQL());
            this.__doSetParameters((PreparedStatement)_statement);
            this.__doRegisterOutParams((CallableStatement)_statement);
            if (this.getAccessorConfig() != null) {
                _context = new AccessorEventContext(_statement, Type.OPT.PROCEDURE);
                this.getAccessorConfig().beforeStatementExecution(_context);
            }
            if (_flag = _statement.execute()) {
                do {
                    ResultSet _result;
                    if ((_result = _statement.getResultSet()) == null) continue;
                    this.__resultSets.add(this.__resultSetHandler.handle(_result));
                    _result.close();
                } while (_statement.getMoreResults());
            } else {
                int _idx = this.getParameters().size() + 1;
                for (Integer _paramType : this.__outParams) {
                    this.__resultProcessor.process(_idx, _paramType, _statement.getObject(_idx));
                    ++_idx;
                }
            }
            n = -1;
        }
        catch (Exception ex) {
            try {
                _hasEx = true;
                throw ex;
            }
            catch (Throwable throwable) {
                if (!_hasEx && this.getAccessorConfig() != null && _context != null) {
                    this.getAccessorConfig().afterStatementExecution(_context);
                }
                if (_statement != null) {
                    _statement.close();
                }
                throw throwable;
            }
        }
        if (!_hasEx && this.getAccessorConfig() != null && _context != null) {
            this.getAccessorConfig().afterStatementExecution(_context);
        }
        if (_statement != null) {
            _statement.close();
        }
        return n;
    }

    protected String __doBuildCallSQL() {
        ArrayList<String> _params = new ArrayList<String>();
        for (int i = 0; i < this.getParameters().size() + this.__outParams.size(); ++i) {
            _params.add("?");
        }
        this.sql = "{CALL " + this.getSQL() + (_params.isEmpty() ? "()" : "(" + StringUtils.join(_params, (char)',') + ")") + "}";
        return this.sql;
    }

    protected void __doRegisterOutParams(CallableStatement statement) throws SQLException {
        int _idx = this.getParameters().size() + 1;
        for (Integer _type : this.__outParams) {
            statement.registerOutParameter(_idx++, (int)_type);
        }
    }

    @Override
    public IProcedureOperator<T> addParameter(SQLParameter parameter) {
        return (IProcedureOperator)super.addParameter(parameter);
    }

    @Override
    public IProcedureOperator<T> addParameter(Object parameter) {
        return (IProcedureOperator)super.addParameter(parameter);
    }

    @Override
    public IProcedureOperator<T> addOutParameter(Integer sqlParamType) {
        this.__outParams.add(sqlParamType);
        return this;
    }

    @Override
    public IProcedureOperator<T> setOutResultProcessor(IProcedureOperator.IOutResultProcessor outResultProcessor) {
        this.__resultProcessor = outResultProcessor;
        return this;
    }

    @Override
    public IProcedureOperator<T> setResultSetHandler(IResultSetHandler<T> resultSetHandler) {
        this.__resultSetHandler = resultSetHandler;
        return this;
    }

    @Override
    public List<List<T>> getResultSets() {
        return this.__resultSets;
    }
}

