/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.platform.persistence.jdbc.base.impl;

import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import net.ymate.platform.persistence.base.Type;
import net.ymate.platform.persistence.jdbc.IConnectionHolder;
import net.ymate.platform.persistence.jdbc.base.AbstractOperator;
import net.ymate.platform.persistence.jdbc.base.AccessorEventContext;
import net.ymate.platform.persistence.jdbc.base.IAccessorConfig;
import net.ymate.platform.persistence.jdbc.base.IBatchUpdateOperator;
import net.ymate.platform.persistence.jdbc.base.IOperator;
import net.ymate.platform.persistence.jdbc.base.SQLBatchParameter;
import net.ymate.platform.persistence.jdbc.base.SQLParameter;
import net.ymate.platform.persistence.jdbc.base.impl.BaseAccessor;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BatchUpdateOperator
extends AbstractOperator
implements IBatchUpdateOperator {
    private static final Log _LOG = LogFactory.getLog(BatchUpdateOperator.class);
    private int[] effectCounts;
    private int effectCountsTotal;
    private List<String> __batchSQL = new ArrayList<String>();
    private List<SQLBatchParameter> __batchParameters = new ArrayList<SQLBatchParameter>();

    public BatchUpdateOperator(IConnectionHolder connectionHolder) {
        this(null, connectionHolder, null);
    }

    public BatchUpdateOperator(IConnectionHolder connectionHolder, IAccessorConfig accessorConfig) {
        this(null, connectionHolder, accessorConfig);
    }

    public BatchUpdateOperator(String sql, IConnectionHolder connectionHolder) {
        this(sql, connectionHolder, null);
    }

    public BatchUpdateOperator(String sql, IConnectionHolder connectionHolder, IAccessorConfig accessorConfig) {
        super(sql, connectionHolder, accessorConfig);
    }

    @Override
    protected String __doSerializeParameters() {
        ArrayList<SQLBatchParameter> _params = new ArrayList<SQLBatchParameter>(this.__batchParameters);
        _params.addAll(this.__batchSQL);
        return ((Object)_params).toString();
    }

    @Override
    protected int __doExecute() throws Exception {
        int n;
        Statement _statement = null;
        AccessorEventContext _context = null;
        boolean _hasEx = false;
        try {
            BaseAccessor _accessor = new BaseAccessor(this.getAccessorConfig());
            if (StringUtils.isNotBlank((String)this.getSQL())) {
                _statement = _accessor.getPreparedStatement(this.getConnectionHolder().getConnection(), this.getSQL());
                for (SQLBatchParameter _batchParam : this.__batchParameters) {
                    for (int i = 0; i < _batchParam.getParameters().size(); ++i) {
                        SQLParameter _param = _batchParam.getParameters().get(i);
                        if (_param.getValue() == null) {
                            ((PreparedStatement)_statement).setNull(i + 1, 0);
                            continue;
                        }
                        ((PreparedStatement)_statement).setObject(i + 1, _param.getValue());
                    }
                    ((PreparedStatement)_statement).addBatch();
                }
            } else {
                _statement = _accessor.getStatement(this.getConnectionHolder().getConnection());
            }
            for (String _batchSQL : this.__batchSQL) {
                _statement.addBatch(_batchSQL);
            }
            if (this.getAccessorConfig() != null) {
                _context = new AccessorEventContext(_statement, Type.OPT.BATCH_UPDATE);
                this.getAccessorConfig().beforeStatementExecution(_context);
            }
            this.effectCounts = _statement.executeBatch();
            for (Object _c : (Object)this.effectCounts) {
                this.effectCountsTotal += _c;
            }
            n = this.effectCountsTotal;
        }
        catch (Exception ex) {
            try {
                _hasEx = true;
                throw ex;
            }
            catch (Throwable throwable) {
                if (!_hasEx && this.getAccessorConfig() != null && _context != null) {
                    this.getAccessorConfig().afterStatementExecution(_context);
                }
                if (_statement != null) {
                    _statement.clearBatch();
                    _statement.close();
                }
                throw throwable;
            }
        }
        if (!_hasEx && this.getAccessorConfig() != null && _context != null) {
            this.getAccessorConfig().afterStatementExecution(_context);
        }
        if (_statement != null) {
            _statement.clearBatch();
            _statement.close();
        }
        return n;
    }

    @Override
    public int[] getEffectCounts() {
        return this.effectCounts;
    }

    @Override
    public int getEffectCountsTotal() {
        return this.effectCountsTotal;
    }

    @Override
    public IBatchUpdateOperator addBatchSQL(String sql) {
        this.__batchSQL.add(sql);
        return this;
    }

    @Override
    public IBatchUpdateOperator addBatchParameter(SQLBatchParameter parameter) {
        if (StringUtils.isBlank((String)this.getSQL())) {
            throw new UnsupportedOperationException();
        }
        if (parameter != null) {
            this.__batchParameters.add(parameter);
        }
        return this;
    }

    @Override
    public List<SQLBatchParameter> getBatchParameters() {
        return this.__batchParameters;
    }

    @Override
    public IOperator addParameter(Object parameter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IOperator addParameter(SQLParameter parameter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<SQLParameter> getParameters() {
        throw new UnsupportedOperationException();
    }
}

