/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.platform.persistence.jdbc.base.impl;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import net.ymate.platform.persistence.jdbc.base.IAccessor;
import net.ymate.platform.persistence.jdbc.base.IAccessorConfig;

public class BaseAccessor
implements IAccessor {
    private IAccessorConfig accessorConfig;

    public BaseAccessor() {
    }

    public BaseAccessor(IAccessorConfig accessorConfig) {
        this.accessorConfig = accessorConfig;
    }

    protected void __doSetupStatement(Statement statement) throws SQLException {
        if (statement != null && this.accessorConfig != null) {
            if (this.accessorConfig.getFetchDirection() > 0) {
                statement.setFetchDirection(this.accessorConfig.getFetchDirection());
            }
            if (this.accessorConfig.getFetchSize() > 0) {
                statement.setFetchSize(this.accessorConfig.getFetchSize());
            }
            if (this.accessorConfig.getMaxRows() > 0) {
                statement.setMaxRows(this.accessorConfig.getMaxRows());
            }
            if (this.accessorConfig.getQueryTimeout() > 0) {
                statement.setQueryTimeout(this.accessorConfig.getQueryTimeout());
            }
            if (this.accessorConfig.getMaxFieldSize() > 0) {
                statement.setMaxFieldSize(this.accessorConfig.getMaxFieldSize());
            }
        }
    }

    @Override
    public Statement getStatement(Connection conn) throws Exception {
        Statement _statement = null;
        if (this.accessorConfig != null) {
            _statement = this.accessorConfig.getStatement(conn);
        }
        if (_statement == null) {
            _statement = conn.createStatement();
        }
        this.__doSetupStatement(_statement);
        return _statement;
    }

    @Override
    public PreparedStatement getPreparedStatement(Connection conn, String sql) throws Exception {
        PreparedStatement _statement = null;
        if (this.accessorConfig != null) {
            _statement = this.accessorConfig.getPreparedStatement(conn, sql);
        }
        if (_statement == null) {
            _statement = conn.prepareStatement(sql);
        }
        this.__doSetupStatement(_statement);
        return _statement;
    }

    @Override
    public CallableStatement getCallableStatement(Connection conn, String sql) throws Exception {
        CallableStatement _statement = null;
        if (this.accessorConfig != null) {
            _statement = this.accessorConfig.getCallableStatement(conn, sql);
        }
        if (_statement == null) {
            _statement = conn.prepareCall(sql);
        }
        this.__doSetupStatement(_statement);
        return _statement;
    }

    @Override
    public IAccessorConfig getAccessorConfig() {
        return this.accessorConfig;
    }

    public void setAccessorConfig(IAccessorConfig accessorConfig) {
        this.accessorConfig = accessorConfig;
    }
}

