/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.platform.persistence.jdbc;

import java.util.HashMap;
import java.util.Map;
import net.ymate.platform.core.Version;
import net.ymate.platform.core.YMP;
import net.ymate.platform.core.beans.IBeanHandler;
import net.ymate.platform.core.module.IModule;
import net.ymate.platform.core.module.annotation.Module;
import net.ymate.platform.persistence.IDataSourceRouter;
import net.ymate.platform.persistence.jdbc.DataSourceCfgMeta;
import net.ymate.platform.persistence.jdbc.DatabaseEvent;
import net.ymate.platform.persistence.jdbc.IConnectionHolder;
import net.ymate.platform.persistence.jdbc.IDataSourceAdapter;
import net.ymate.platform.persistence.jdbc.IDatabase;
import net.ymate.platform.persistence.jdbc.IDatabaseModuleCfg;
import net.ymate.platform.persistence.jdbc.ISession;
import net.ymate.platform.persistence.jdbc.ISessionExecutor;
import net.ymate.platform.persistence.jdbc.dialect.IDialect;
import net.ymate.platform.persistence.jdbc.dialect.impl.DB2Dialect;
import net.ymate.platform.persistence.jdbc.dialect.impl.H2Dialect;
import net.ymate.platform.persistence.jdbc.dialect.impl.HSQLDBDialect;
import net.ymate.platform.persistence.jdbc.dialect.impl.MySQLDialect;
import net.ymate.platform.persistence.jdbc.dialect.impl.OracleDialect;
import net.ymate.platform.persistence.jdbc.dialect.impl.PostgreSQLDialect;
import net.ymate.platform.persistence.jdbc.dialect.impl.SQLServerDialect;
import net.ymate.platform.persistence.jdbc.dialect.impl.SQLiteDialect;
import net.ymate.platform.persistence.jdbc.impl.C3P0DataSourceAdapter;
import net.ymate.platform.persistence.jdbc.impl.DBCPDataSourceAdapter;
import net.ymate.platform.persistence.jdbc.impl.DefaultConnectionHolder;
import net.ymate.platform.persistence.jdbc.impl.DefaultDataSourceAdapter;
import net.ymate.platform.persistence.jdbc.impl.DefaultDatabaseModuleCfg;
import net.ymate.platform.persistence.jdbc.impl.DefaultSession;
import net.ymate.platform.persistence.jdbc.impl.JNDIDataSourceAdapter;
import net.ymate.platform.persistence.jdbc.repo.RepoHandler;
import net.ymate.platform.persistence.jdbc.repo.annotation.Repository;
import net.ymate.platform.persistence.jdbc.transaction.Transactions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Module
public class JDBC
implements IModule,
IDatabase {
    public static final Version VERSION = new Version(2, 0, 6, JDBC.class.getPackage().getImplementationVersion(), Version.VersionType.Release);
    private static final Log _LOG = LogFactory.getLog(JDBC.class);
    private static volatile IDatabase __instance;
    private YMP __owner;
    private IDatabaseModuleCfg __moduleCfg;
    private Map<String, IDataSourceAdapter> __dsCaches;
    private boolean __inited;
    public static Map<String, String> DS_ADAPTERS;
    public static Map<DATABASE, String> DB_DRIVERS;
    public static Map<DATABASE, Class<? extends IDialect>> DB_DIALECTS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IDatabase get() {
        if (__instance == null) {
            Version version = VERSION;
            synchronized (version) {
                if (__instance == null) {
                    __instance = (IDatabase)YMP.get().getModule(JDBC.class);
                }
            }
        }
        return __instance;
    }

    public static IDatabase get(YMP owner) {
        return (IDatabase)owner.getModule(JDBC.class);
    }

    public String getName() {
        return "persistence.jdbc";
    }

    public void init(YMP owner) throws Exception {
        if (!this.__inited) {
            _LOG.info((Object)("Initializing ymate-platform-persistence-jdbc-" + VERSION));
            this.__owner = owner;
            this.__moduleCfg = new DefaultDatabaseModuleCfg(owner);
            this.__owner.getEvents().registerEvent(DatabaseEvent.class);
            this.__owner.registerHandler(Repository.class, (IBeanHandler)new RepoHandler(this));
            this.__dsCaches = new HashMap<String, IDataSourceAdapter>();
            for (DataSourceCfgMeta _meta : this.__moduleCfg.getDataSourceCfgs().values()) {
                IDataSourceAdapter _adapter = _meta.getAdapterClass().newInstance();
                _adapter.initialize(this, _meta);
                this.__dsCaches.put(_meta.getName(), _adapter);
            }
            this.__inited = true;
        }
    }

    public boolean isInited() {
        return this.__inited;
    }

    public void destroy() throws Exception {
        if (this.__inited) {
            this.__inited = false;
            for (IDataSourceAdapter _adapter : this.__dsCaches.values()) {
                _adapter.destroy();
            }
            this.__dsCaches = null;
            this.__moduleCfg = null;
            this.__owner = null;
        }
    }

    @Override
    public YMP getOwner() {
        return this.__owner;
    }

    @Override
    public IDatabaseModuleCfg getModuleCfg() {
        return this.__moduleCfg;
    }

    @Override
    public IConnectionHolder getDefaultConnectionHolder() throws Exception {
        String _defaultDSName = this.__moduleCfg.getDataSourceDefaultName();
        return this.getConnectionHolder(_defaultDSName);
    }

    @Override
    public IConnectionHolder getConnectionHolder(String dsName) throws Exception {
        IConnectionHolder _returnValue;
        if (Transactions.get() != null) {
            _returnValue = Transactions.get().getConnectionHolder(dsName);
            if (_returnValue == null) {
                _returnValue = new DefaultConnectionHolder(this.__dsCaches.get(dsName));
                Transactions.get().registerConnectionHolder(_returnValue);
            }
        } else {
            _returnValue = new DefaultConnectionHolder(this.__dsCaches.get(dsName));
        }
        return _returnValue;
    }

    @Override
    public void releaseConnectionHolder(IConnectionHolder connectionHolder) throws Exception {
        if (Transactions.get() == null && connectionHolder != null) {
            connectionHolder.release();
        }
    }

    @Override
    public <T> T openSession(ISessionExecutor<T> executor) throws Exception {
        return this.openSession(this.getDefaultConnectionHolder(), executor);
    }

    @Override
    public <T> T openSession(String dsName, ISessionExecutor<T> executor) throws Exception {
        return this.openSession(this.getConnectionHolder(dsName), executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T openSession(IConnectionHolder connectionHolder, ISessionExecutor<T> executor) throws Exception {
        DefaultSession _session = new DefaultSession(this, connectionHolder);
        try {
            T t = executor.execute(_session);
            return t;
        }
        finally {
            _session.close();
        }
    }

    @Override
    public <T> T openSession(IDataSourceRouter dataSourceRouter, ISessionExecutor<T> executor) throws Exception {
        return this.openSession(this.getConnectionHolder(dataSourceRouter.getDataSourceName()), executor);
    }

    @Override
    public ISession openSession() throws Exception {
        return new DefaultSession(this, this.getDefaultConnectionHolder());
    }

    @Override
    public ISession openSession(String dsName) throws Exception {
        return new DefaultSession(this, this.getConnectionHolder(dsName));
    }

    @Override
    public ISession openSession(IConnectionHolder connectionHolder) throws Exception {
        return new DefaultSession(this, connectionHolder);
    }

    @Override
    public ISession openSession(IDataSourceRouter dataSourceRouter) throws Exception {
        return new DefaultSession(this, this.getConnectionHolder(dataSourceRouter.getDataSourceName()));
    }

    static {
        DS_ADAPTERS = new HashMap<String, String>();
        DS_ADAPTERS.put("default", DefaultDataSourceAdapter.class.getName());
        DS_ADAPTERS.put("jndi", JNDIDataSourceAdapter.class.getName());
        DS_ADAPTERS.put("c3p0", C3P0DataSourceAdapter.class.getName());
        DS_ADAPTERS.put("dbcp", DBCPDataSourceAdapter.class.getName());
        DB_DRIVERS = new HashMap<DATABASE, String>();
        DB_DRIVERS.put(DATABASE.MYSQL, "com.mysql.jdbc.Driver");
        DB_DRIVERS.put(DATABASE.ORACLE, "oracle.jdbc.OracleDriver");
        DB_DRIVERS.put(DATABASE.SQLSERVER, "com.microsoft.sqlserver.jdbc.SQLServerDriver");
        DB_DRIVERS.put(DATABASE.DB2, "com.ibm.db2.jcc.DB2Driver");
        DB_DRIVERS.put(DATABASE.SQLITE, "org.sqlite.JDBC");
        DB_DRIVERS.put(DATABASE.POSTGRESQL, "org.postgresql.Driver");
        DB_DRIVERS.put(DATABASE.HSQLDB, "org.hsqldb.jdbcDriver");
        DB_DRIVERS.put(DATABASE.H2, "org.h2.Driver");
        DB_DIALECTS = new HashMap<DATABASE, Class<? extends IDialect>>();
        DB_DIALECTS.put(DATABASE.MYSQL, MySQLDialect.class);
        DB_DIALECTS.put(DATABASE.ORACLE, OracleDialect.class);
        DB_DIALECTS.put(DATABASE.SQLSERVER, SQLServerDialect.class);
        DB_DIALECTS.put(DATABASE.DB2, DB2Dialect.class);
        DB_DIALECTS.put(DATABASE.SQLITE, SQLiteDialect.class);
        DB_DIALECTS.put(DATABASE.POSTGRESQL, PostgreSQLDialect.class);
        DB_DIALECTS.put(DATABASE.HSQLDB, HSQLDBDialect.class);
        DB_DIALECTS.put(DATABASE.H2, H2Dialect.class);
    }

    public static enum TRANSACTION {
        NONE(0),
        READ_COMMITTED(2),
        READ_UNCOMMITTED(1),
        REPEATABLE_READ(4),
        SERIALIZABLE(8);

        private int _level;

        private TRANSACTION(int level) {
            this._level = level;
        }

        public int getLevel() {
            return this._level;
        }

        public void setLevel(int level) {
            this._level = level;
        }
    }

    public static enum DATABASE {
        MYSQL,
        ORACLE,
        SQLSERVER,
        DB2,
        SQLITE,
        POSTGRESQL,
        HSQLDB,
        H2,
        UNKNOWN;

    }
}

