/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.platform.persistence.jdbc;

import java.sql.DriverManager;
import java.sql.SQLException;
import net.ymate.platform.core.support.IPasswordProcessor;
import net.ymate.platform.core.util.ClassUtils;
import net.ymate.platform.core.util.RuntimeUtils;
import net.ymate.platform.persistence.jdbc.DataSourceCfgMeta;
import net.ymate.platform.persistence.jdbc.IDataSourceAdapter;
import net.ymate.platform.persistence.jdbc.IDatabase;
import net.ymate.platform.persistence.jdbc.JDBC;
import net.ymate.platform.persistence.jdbc.dialect.IDialect;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractDataSourceAdapter
implements IDataSourceAdapter {
    private static final Log _LOG = LogFactory.getLog(AbstractDataSourceAdapter.class);
    private IDatabase __owner;
    protected DataSourceCfgMeta __cfgMeta;
    private IDialect __dialect;
    protected boolean __inited;

    @Override
    public void initialize(IDatabase owner, DataSourceCfgMeta cfgMeta) throws Exception {
        if (!this.__inited) {
            this.__owner = owner;
            this.__cfgMeta = cfgMeta;
            this.__dialect = StringUtils.isNotBlank((String)cfgMeta.getDialectClass()) ? (IDialect)ClassUtils.impl((String)this.__cfgMeta.getDialectClass(), IDialect.class, this.getClass()) : JDBC.DB_DIALECTS.get((Object)this.__cfgMeta.getType()).newInstance();
            if (this.__dialect != null && StringUtils.isNotBlank((String)this.__cfgMeta.getIdentifierQuote())) {
                char[] _quotes = this.__cfgMeta.getIdentifierQuote().toCharArray();
                if (_quotes.length == 1) {
                    this.__dialect.setIdentifierQuote(this.__cfgMeta.getIdentifierQuote(), this.__cfgMeta.getIdentifierQuote());
                } else if (_quotes.length > 1) {
                    this.__dialect.setIdentifierQuote(Character.toString(_quotes[0]), Character.toString(_quotes[1]));
                }
            }
            this.__inited = this.tryInitializeIfNeed();
        }
    }

    @Override
    public boolean tryInitializeIfNeed() throws Exception {
        if (!this.__inited) {
            try {
                this.__doInit();
                this.__inited = true;
            }
            catch (Exception e) {
                _LOG.warn((Object)("Data source '" + this.__cfgMeta.getName() + "' initialization failed..."), RuntimeUtils.unwrapThrow((Throwable)e));
            }
        }
        return this.__inited;
    }

    @Override
    public DataSourceCfgMeta getDataSourceCfgMeta() {
        return this.__cfgMeta;
    }

    protected String __doGetPasswordDecryptIfNeed() throws Exception {
        if (StringUtils.isNotBlank((String)this.__cfgMeta.getPassword()) && this.__cfgMeta.isPasswordEncrypted()) {
            if (this.__cfgMeta.getPasswordClass() != null) {
                return this.__cfgMeta.getPasswordClass().newInstance().decrypt(this.__cfgMeta.getPassword());
            }
            return ((IPasswordProcessor)this.__owner.getOwner().getConfig().getDefaultPasswordClass().newInstance()).decrypt(this.__cfgMeta.getPassword());
        }
        return this.__cfgMeta.getPassword();
    }

    protected abstract void __doInit() throws Exception;

    @Override
    public IDialect getDialect() {
        return this.__dialect;
    }

    @Override
    public void destroy() {
        if (this.__inited) {
            this.__inited = false;
            try {
                DriverManager.deregisterDriver(DriverManager.getDriver(this.__cfgMeta.getConnectionUrl()));
            }
            catch (SQLException e) {
                _LOG.warn((Object)"", (Throwable)e);
            }
            this.__cfgMeta = null;
            this.__dialect = null;
            this.__owner = null;
        }
    }
}

