/*
 * Copyright 2007-2017 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.ymate.platform.persistence.jdbc;

import net.ymate.platform.persistence.jdbc.dialect.IDialect;

import java.sql.Connection;

/**
 * 数据源适配器接口
 *
 * @author 刘镇 (suninformation@163.com) on 2012-12-29 上午12:28:41
 * @version 1.0
 */
public interface IDataSourceAdapter {

    /**
     * 数据源适配器初始化
     *
     * @param owner   所属JDBC模块对象
     * @param cfgMeta 数据源配置参数
     * @throws Exception 可能产生的异常
     */
    void initialize(IDatabase owner, DataSourceCfgMeta cfgMeta) throws Exception;

    /**
     * @return 判断是否已初始化, 若尚未执行则尝试初始化
     * @throws Exception 可能产生的异常
     */
    boolean tryInitializeIfNeed() throws Exception;

    /**
     * @return 获取数据源配置参数
     */
    DataSourceCfgMeta getDataSourceCfgMeta();

    /**
     * @return 获取数据库连接
     * @throws Exception 可能产生的异常
     */
    Connection getConnection() throws Exception;

    /**
     * @return 获取数据库方言
     */
    IDialect getDialect();

    /**
     * 销毁数据源适配器
     */
    void destroy();
}
