/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.platform.persistence.jdbc.transaction;

import net.ymate.platform.core.util.RuntimeUtils;
import net.ymate.platform.persistence.jdbc.JDBC;
import net.ymate.platform.persistence.jdbc.transaction.ITrade;
import net.ymate.platform.persistence.jdbc.transaction.ITransaction;
import net.ymate.platform.persistence.jdbc.transaction.Trade;
import net.ymate.platform.persistence.jdbc.transaction.impl.DefaultTransaction;

public class Transactions {
    private static final ThreadLocal<ITransaction> __TRANS_LOCAL = new ThreadLocal();
    private static final ThreadLocal<Integer> __COUNT = new ThreadLocal();

    public static ITransaction get() {
        return __TRANS_LOCAL.get();
    }

    static void __begin(JDBC.TRANSACTION level) throws Exception {
        if (__TRANS_LOCAL.get() == null) {
            __TRANS_LOCAL.set(new DefaultTransaction(level));
            __COUNT.set(0);
        }
        __COUNT.set(__COUNT.get() + 1);
    }

    static void __commit() throws Exception {
        if (__COUNT.get() > 0) {
            __COUNT.set(__COUNT.get() - 1);
        }
        if (__COUNT.get() == 0) {
            __TRANS_LOCAL.get().commit();
        }
    }

    static void __rollback(int number) throws Exception {
        __COUNT.set(number);
        if (__COUNT.get() == 0) {
            __TRANS_LOCAL.get().rollback();
        } else {
            __COUNT.set(__COUNT.get() - 1);
        }
    }

    static void __close() throws Exception {
        if (__COUNT.get() != null && __COUNT.get() == 0) {
            try {
                __TRANS_LOCAL.get().close();
            }
            finally {
                __TRANS_LOCAL.remove();
                __COUNT.remove();
            }
        }
    }

    public static void execute(ITrade ... trades) throws Exception {
        Transactions.execute(JDBC.TRANSACTION.READ_COMMITTED, trades);
    }

    public static void execute(JDBC.TRANSACTION level, ITrade ... trades) throws Exception {
        int _number = __COUNT.get() == null ? 0 : __COUNT.get();
        try {
            Transactions.__begin(level);
            for (ITrade trade : trades) {
                trade.deal();
            }
            Transactions.__commit();
        }
        catch (Throwable e) {
            try {
                Transactions.__rollback(_number);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new Exception(RuntimeUtils.unwrapThrow((Throwable)e));
        }
        finally {
            try {
                Transactions.__close();
            }
            catch (Exception exception) {}
        }
    }

    public static <T> T execute(Trade<T> trade) throws Exception {
        return Transactions.execute(JDBC.TRANSACTION.READ_COMMITTED, trade);
    }

    public static <T> T execute(JDBC.TRANSACTION level, Trade<T> trade) throws Exception {
        T t;
        int _number = __COUNT.get() == null ? 0 : __COUNT.get();
        try {
            Transactions.__begin(level);
            trade.deal();
            Transactions.__commit();
            t = trade.getReturns();
        }
        catch (Throwable e) {
            try {
                Transactions.__rollback(_number);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new Exception(RuntimeUtils.unwrapThrow((Throwable)e));
        }
        finally {
            try {
                Transactions.__close();
            }
            catch (Exception exception) {}
        }
        return t;
    }
}

