/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.platform.persistence.jdbc.support;

import java.util.HashMap;
import java.util.Map;
import net.ymate.platform.core.support.IPasswordProcessor;
import net.ymate.platform.persistence.jdbc.IDataSourceAdapter;
import net.ymate.platform.persistence.jdbc.JDBC;
import net.ymate.platform.persistence.jdbc.dialect.IDialect;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.StringUtils;

public class DataSourceConfigurable {
    private Map<String, String> __configs = new HashMap<String, String>();
    private String name;

    public static DataSourceConfigurable create(String name) {
        return new DataSourceConfigurable(name);
    }

    public DataSourceConfigurable(String name) {
        if (StringUtils.isBlank((String)name)) {
            throw new NullArgumentException("name");
        }
        this.name = name;
    }

    private void __putItem(String key, String value) {
        if (StringUtils.isBlank((String)key) || StringUtils.isBlank((String)value)) {
            return;
        }
        this.__configs.put("ds." + this.name + "." + key, value);
    }

    public DataSourceConfigurable connectionUrl(String connectionUrl) {
        this.__putItem("connection_url", connectionUrl);
        return this;
    }

    public DataSourceConfigurable username(String username) {
        this.__putItem("username", username);
        return this;
    }

    public DataSourceConfigurable password(String password) {
        this.__putItem("password", password);
        return this;
    }

    public DataSourceConfigurable passwordEncrypted(boolean passwordEncrypted) {
        this.__putItem("password_encrypted", String.valueOf(passwordEncrypted));
        return this;
    }

    public DataSourceConfigurable passwordClass(Class<? extends IPasswordProcessor> passwordClass) {
        this.__putItem("password_class", passwordClass.getName());
        return this;
    }

    public DataSourceConfigurable showSql(boolean showSql) {
        this.__putItem("show_sql", String.valueOf(showSql));
        return this;
    }

    public DataSourceConfigurable stackTraces(boolean stackTraces) {
        this.__putItem("stack_traces", String.valueOf(stackTraces));
        return this;
    }

    public DataSourceConfigurable stackTraceDepth(int stackTraceDepth) {
        this.__putItem("stack_trace_depth", String.valueOf(stackTraceDepth));
        return this;
    }

    public DataSourceConfigurable stackTracePackage(String stackTracePackage) {
        this.__putItem("stack_trace_package", stackTracePackage);
        return this;
    }

    public DataSourceConfigurable tablePrefix(String tablePrefix) {
        this.__putItem("table_prefix", tablePrefix);
        return this;
    }

    public DataSourceConfigurable identifierQuote(String identifierQuote) {
        this.__putItem("identifier_quote", identifierQuote);
        return this;
    }

    public DataSourceConfigurable adapterClass(String adapterClass) {
        this.__putItem("adapter_class", adapterClass);
        return this;
    }

    public DataSourceConfigurable adapterClass(Class<? extends IDataSourceAdapter> adapterClass) {
        this.__putItem("adapter_class", adapterClass.getName());
        return this;
    }

    public DataSourceConfigurable type(JDBC.DATABASE type) {
        this.__putItem("type", type.name());
        return this;
    }

    public DataSourceConfigurable dialectClass(Class<? extends IDialect> dialectClass) {
        this.__putItem("dialect_class", dialectClass.getName());
        return this;
    }

    public DataSourceConfigurable driverClass(String driverClass) {
        this.__putItem("driver_class", driverClass);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> toMap() {
        return this.__configs;
    }
}

