/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.platform.persistence.jdbc.scaffold;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.ymate.platform.core.IConfig;
import net.ymate.platform.core.YMP;
import net.ymate.platform.core.lang.BlurObject;
import net.ymate.platform.core.lang.PairObject;
import net.ymate.platform.core.util.ClassUtils;
import net.ymate.platform.core.util.RuntimeUtils;
import net.ymate.platform.persistence.base.EntityMeta;
import net.ymate.platform.persistence.jdbc.scaffold.IEntityNamedFilter;
import org.apache.commons.lang.StringUtils;

public class ConfigInfo {
    private final String dbName;
    private final String dbUserName;
    private final boolean removePrefix;
    private final List<String> tablePrefixes;
    private final List<String> tableList;
    private final List<String> tableExcludeList;
    private final boolean useBaseEntity;
    private final boolean useClassSuffix;
    private final boolean useChainMode;
    private final boolean useStateSupport;
    private final IEntityNamedFilter namedFilter;
    private final List<String> readonlyFields;
    private final String packageName;
    private final String outputPath;

    public ConfigInfo(YMP owner) {
        IConfig _config = owner.getConfig();
        this.useBaseEntity = BlurObject.bind((Object)_config.getParam("jdbc.use_base_entity")).toBooleanValue();
        this.useClassSuffix = BlurObject.bind((Object)_config.getParam("jdbc.use_class_suffix")).toBooleanValue();
        this.useChainMode = BlurObject.bind((Object)_config.getParam("jdbc.use_chain_mode")).toBooleanValue();
        this.useStateSupport = BlurObject.bind((Object)_config.getParam("jdbc.use_state_support")).toBooleanValue();
        this.packageName = _config.getParam("jdbc.package_name", "packages");
        this.outputPath = RuntimeUtils.replaceEnvVariable((String)owner.getConfig().getParam("jdbc.output_path", "${root}"));
        this.dbName = _config.getParam("jdbc.db_name");
        this.dbUserName = _config.getParam("jdbc.db_username");
        this.tablePrefixes = Arrays.asList(StringUtils.split((String)_config.getParam("jdbc.table_prefix", ""), (char)'|'));
        this.removePrefix = new BlurObject((Object)_config.getParam("jdbc.remove_table_prefix")).toBooleanValue();
        this.tableExcludeList = Arrays.asList(StringUtils.split((String)_config.getParam("jdbc.table_exclude_list", "").toLowerCase(), (String)"|"));
        this.tableList = Arrays.asList(StringUtils.split((String)_config.getParam("jdbc.table_list", ""), (String)"|"));
        this.namedFilter = (IEntityNamedFilter)ClassUtils.impl((String)_config.getParam("jdbc.named_filter_class"), IEntityNamedFilter.class, this.getClass());
        this.readonlyFields = Arrays.asList(StringUtils.split((String)_config.getParam("jdbc.readonly_field_list", "").toLowerCase(), (char)'|'));
    }

    public ConfigInfo(String dbName, String dbUserName, boolean removePrefix, List<String> tablePrefixes, List<String> tableList, List<String> tableExcludeList, boolean useBaseEntity, boolean useClassSuffix, boolean useChainMode, boolean useStateSupport, IEntityNamedFilter namedFilter, List<String> readonlyFields, String packageName, String outputPath) {
        this.dbName = dbName;
        this.dbUserName = dbUserName;
        this.removePrefix = removePrefix;
        this.tablePrefixes = tablePrefixes;
        this.tableList = tableList;
        this.tableExcludeList = tableExcludeList;
        this.useBaseEntity = useBaseEntity;
        this.useClassSuffix = useClassSuffix;
        this.useChainMode = useChainMode;
        this.useStateSupport = useStateSupport;
        this.namedFilter = namedFilter;
        this.readonlyFields = readonlyFields;
        this.packageName = StringUtils.defaultIfBlank((String)packageName, (String)"packages");
        this.outputPath = RuntimeUtils.replaceEnvVariable((String)StringUtils.defaultIfBlank((String)outputPath, (String)"${root}"));
    }

    public PairObject<String, String> buildNamePrefix(String tableName) {
        String _modelName = null;
        for (String _prefix : this.tablePrefixes) {
            if (!tableName.startsWith(_prefix)) continue;
            if (this.removePrefix) {
                tableName = tableName.substring(_prefix.length());
            }
            _modelName = StringUtils.capitalize((String)EntityMeta.propertyNameToFieldName((String)this.namedFilter(tableName)));
            break;
        }
        if (StringUtils.isBlank(_modelName)) {
            _modelName = StringUtils.capitalize((String)EntityMeta.propertyNameToFieldName((String)this.namedFilter(tableName)));
        }
        return new PairObject(_modelName, (Object)tableName);
    }

    public String namedFilter(String original) {
        if (this.namedFilter != null) {
            return StringUtils.defaultIfBlank((String)this.namedFilter.doFilter(original), (String)original);
        }
        return original;
    }

    public Map<String, Object> toMap() {
        Map _returnValue = ClassUtils.wrapper((Object)this).toMap(new ClassUtils.IFieldValueFilter(){
            private final List<String> __fields = Arrays.asList("packageName", "useBaseEntity", "useClassSuffix", "useChainMode", "useStateSupport");

            public boolean filter(String fieldName, Object fieldValue) {
                return !this.__fields.contains(fieldName);
            }
        });
        _returnValue.put("lastUpdateTime", new Date());
        return _returnValue;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getDbUserName() {
        return this.dbUserName;
    }

    public boolean isRemovePrefix() {
        return this.removePrefix;
    }

    public List<String> getTablePrefixes() {
        return this.tablePrefixes;
    }

    public List<String> getTableList() {
        return this.tableList;
    }

    public List<String> getTableExcludeList() {
        return this.tableExcludeList;
    }

    public boolean isUseBaseEntity() {
        return this.useBaseEntity;
    }

    public boolean isUseClassSuffix() {
        return this.useClassSuffix;
    }

    public boolean isUseChainMode() {
        return this.useChainMode;
    }

    public boolean isUseStateSupport() {
        return this.useStateSupport;
    }

    public IEntityNamedFilter getNamedFilter() {
        return this.namedFilter;
    }

    public List<String> getReadonlyFields() {
        return this.readonlyFields;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getOutputPath() {
        return this.outputPath;
    }
}

