/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.platform.persistence.jdbc.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.ymate.platform.persistence.Fields;
import net.ymate.platform.persistence.IFunction;
import net.ymate.platform.persistence.Page;
import net.ymate.platform.persistence.Params;
import net.ymate.platform.persistence.base.EntityMeta;
import net.ymate.platform.persistence.base.IEntity;
import net.ymate.platform.persistence.jdbc.dialect.IDialect;
import net.ymate.platform.persistence.jdbc.query.IDBLocker;
import net.ymate.platform.persistence.jdbc.query.Join;
import net.ymate.platform.persistence.jdbc.query.Query;
import net.ymate.platform.persistence.jdbc.query.SQL;
import net.ymate.platform.persistence.jdbc.query.Union;
import net.ymate.platform.persistence.jdbc.query.Where;
import org.apache.commons.lang.StringUtils;

public final class Select
extends Query<Select> {
    private List<String> __froms = new ArrayList<String>();
    private Fields __fields = Fields.create((String[])new String[0]);
    private List<Join> __joins = new ArrayList<Join>();
    private Where __where;
    private List<Union> __unions = new ArrayList<Union>();
    private String __alias;
    private boolean __distinct;
    private IDBLocker __dbLocker;
    private Page __page;

    public static Select create() {
        return new Select();
    }

    public static Select create(Class<? extends IEntity> entityClass) {
        return new Select().from(null, entityClass, null);
    }

    public static Select create(String prefix, Class<? extends IEntity> entityClass) {
        return new Select().from(prefix, entityClass, null);
    }

    public static Select create(Class<? extends IEntity> entityClass, String alias) {
        return new Select().from(null, entityClass, alias);
    }

    public static Select create(String prefix, Class<? extends IEntity> entityClass, String alias) {
        return new Select().from(prefix, entityClass, alias);
    }

    public static Select create(Select select) {
        Select _target = new Select(null, select.toString(), null, false);
        _target.where().param(select.getParams());
        return _target;
    }

    public static Select create(String prefix, String from, String alias) {
        return new Select(prefix, from, alias, true);
    }

    public static Select create(String from, String alias) {
        return new Select(null, from, alias, true);
    }

    public static Select create(String from, String alias, boolean safePrefix) {
        return new Select(null, from, alias, safePrefix);
    }

    public static Select create(String from) {
        return new Select(null, from, null, true);
    }

    public static Select create(String from, boolean safePrefix) {
        return new Select(null, from, null, safePrefix);
    }

    private Select() {
    }

    private Select(String prefix, String from, String alias, boolean safePrefix) {
        this();
        if (safePrefix) {
            this.from(null, this.__buildSafeTableName(prefix, from, true), alias);
        } else {
            this.from(prefix, from, alias);
        }
    }

    public Select from(Class<? extends IEntity> entityClass) {
        return this.from(null, this.__buildSafeTableName(null, EntityMeta.createAndGet(entityClass), true), null);
    }

    public Select from(Class<? extends IEntity> entityClass, String alias) {
        return this.from(null, this.__buildSafeTableName(null, EntityMeta.createAndGet(entityClass), true), alias);
    }

    public Select from(String prefix, Class<? extends IEntity> entityClass, String alias) {
        return this.from(null, this.__buildSafeTableName(prefix, EntityMeta.createAndGet(entityClass), true), alias);
    }

    public Select from(Select select) {
        Select _target = this.from(null, select.toString(), null);
        _target.where().param(select.getParams());
        return _target;
    }

    public Select from(String tableName, String alias) {
        return this.from(null, this.__buildSafeTableName(null, tableName, true), alias);
    }

    public Select from(String tableName) {
        return this.from(null, this.__buildSafeTableName(null, tableName, true), null);
    }

    public Select from(String prefix, String from, String alias) {
        from = this.__buildSafeTableName(prefix, from, false);
        if (StringUtils.isNotBlank((String)alias)) {
            from = from.concat(" ").concat(alias);
        }
        this.__froms.add(from);
        return this;
    }

    public Fields fields() {
        return this.__fields;
    }

    public Select field(String field) {
        return this.field(field, true);
    }

    public Select field(String field, boolean wrapIdentifier) {
        this.__fields.add(wrapIdentifier ? this.__wrapIdentifierField(field) : field);
        return this;
    }

    public Select field(String prefix, String field) {
        return this.field(prefix, field, true);
    }

    public Select field(String prefix, String field, boolean wrapIdentifier) {
        this.__fields.add(prefix, wrapIdentifier ? this.__wrapIdentifierField(field) : field);
        return this;
    }

    public Select field(String prefix, String field, String alias) {
        return this.field(prefix, field, alias, true);
    }

    public Select field(String prefix, String field, String alias, boolean wrapIdentifier) {
        this.__fields.add(prefix, wrapIdentifier ? this.__wrapIdentifierField(field) : field, alias);
        return this;
    }

    public Select field(Fields fields) {
        return this.field(fields, true);
    }

    public Select field(Fields fields, boolean wrapIdentifier) {
        Fields _field = this.__checkFieldExcluded(fields);
        this.__fields.add(wrapIdentifier ? this.__wrapIdentifierFields(_field.toArray()) : _field);
        return this;
    }

    public Select field(String prefix, Fields fields) {
        return this.field(prefix, fields, true);
    }

    public Select field(String prefix, Fields fields, boolean wrapIdentifier) {
        for (String _field : this.__checkFieldExcluded(fields).fields()) {
            this.__fields.add(prefix, wrapIdentifier ? this.__wrapIdentifierField(_field) : _field);
        }
        return this;
    }

    public Select field(IFunction func, String alias) {
        this.__fields.add(func, alias);
        return this;
    }

    public Select join(Join join) {
        this.__joins.add(join);
        this.where().param(join.params());
        return this;
    }

    public Select union(Union union) {
        this.__unions.add(union);
        this.where().param(union.select().getParams());
        return this;
    }

    public Select where(Where where) {
        this.where().where(where);
        return this;
    }

    public Params getParams() {
        return this.where().getParams();
    }

    public Where where() {
        if (this.__where == null) {
            this.__where = Where.create();
        }
        return this.__where;
    }

    public Select alias(String alias) {
        this.__alias = alias;
        return this;
    }

    public Select distinct() {
        this.__distinct = true;
        return this;
    }

    public Select forUpdate(IDBLocker dbLocker) {
        this.__dbLocker = dbLocker;
        return this;
    }

    public Select page(Page page) {
        this.__page = page;
        return this;
    }

    public Select page(IDialect dialect, Page page) {
        this.dialect(dialect);
        this.__page = page;
        return this;
    }

    public String toString() {
        StringBuilder _selectSB = new StringBuilder("SELECT ");
        if (this.__distinct) {
            _selectSB.append("DISTINCT ");
        }
        if (this.__fields.fields().isEmpty()) {
            _selectSB.append(" * ");
        } else {
            _selectSB.append(StringUtils.join((Collection)this.__fields.fields(), (String)", "));
        }
        _selectSB.append(" FROM ").append(StringUtils.join(this.__froms, (String)", "));
        for (Join _join : this.__joins) {
            _selectSB.append(" ").append(_join);
        }
        if (this.__where != null) {
            _selectSB.append(" ").append(this.__where.toString());
        }
        for (Union _union : this.__unions) {
            _selectSB.append(" UNION ");
            if (_union.isAll()) {
                _selectSB.append("ALL ");
            }
            _selectSB.append(_union.select());
        }
        _selectSB.append(" ");
        if (this.__page != null) {
            _selectSB = new StringBuilder(this.dialect().buildPagedQuerySQL(_selectSB.toString(), this.__page.page(), this.__page.pageSize())).append(" ");
        }
        if (StringUtils.isNotBlank((String)this.__alias)) {
            return "(".concat(_selectSB.toString()).concat(") ").concat(this.__alias);
        }
        if (this.__dbLocker != null) {
            _selectSB.append(this.__dbLocker.toSQL());
        }
        return _selectSB.toString();
    }

    public SQL toSQL() {
        return SQL.create(this);
    }
}

