/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.platform.persistence.jdbc.impl;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.ymate.platform.core.lang.BlurObject;
import net.ymate.platform.core.lang.PairObject;
import net.ymate.platform.core.util.ExpressionUtils;
import net.ymate.platform.core.util.UUIDUtils;
import net.ymate.platform.persistence.Fields;
import net.ymate.platform.persistence.IResultSet;
import net.ymate.platform.persistence.ISessionEvent;
import net.ymate.platform.persistence.IShardingable;
import net.ymate.platform.persistence.Page;
import net.ymate.platform.persistence.Params;
import net.ymate.platform.persistence.SessionEventContext;
import net.ymate.platform.persistence.base.EntityMeta;
import net.ymate.platform.persistence.base.IEntity;
import net.ymate.platform.persistence.base.IEntityPK;
import net.ymate.platform.persistence.base.ShardingList;
import net.ymate.platform.persistence.base.Type;
import net.ymate.platform.persistence.impl.DefaultResultSet;
import net.ymate.platform.persistence.jdbc.DatabaseEvent;
import net.ymate.platform.persistence.jdbc.IConnectionHolder;
import net.ymate.platform.persistence.jdbc.IDatabase;
import net.ymate.platform.persistence.jdbc.ISession;
import net.ymate.platform.persistence.jdbc.JDBC;
import net.ymate.platform.persistence.jdbc.base.AccessorEventContext;
import net.ymate.platform.persistence.jdbc.base.IAccessorConfig;
import net.ymate.platform.persistence.jdbc.base.IResultSetHandler;
import net.ymate.platform.persistence.jdbc.base.SQLBatchParameter;
import net.ymate.platform.persistence.jdbc.base.impl.ArrayResultSetHandler;
import net.ymate.platform.persistence.jdbc.base.impl.BatchUpdateOperator;
import net.ymate.platform.persistence.jdbc.base.impl.DefaultQueryOperator;
import net.ymate.platform.persistence.jdbc.base.impl.DefaultUpdateOperator;
import net.ymate.platform.persistence.jdbc.base.impl.EntityResultSetHandler;
import net.ymate.platform.persistence.jdbc.dialect.IDialect;
import net.ymate.platform.persistence.jdbc.dialect.impl.OracleDialect;
import net.ymate.platform.persistence.jdbc.query.BatchSQL;
import net.ymate.platform.persistence.jdbc.query.EntitySQL;
import net.ymate.platform.persistence.jdbc.query.SQL;
import net.ymate.platform.persistence.jdbc.query.Where;
import net.ymate.platform.persistence.jdbc.support.BaseEntity;
import net.ymate.platform.persistence.jdbc.transaction.Transactions;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class DefaultSession
implements ISession {
    private IDatabase __owner;
    private String __id;
    private IConnectionHolder __connectionHolder;
    private IDialect __dialect;
    private String __tablePrefix;
    private ISessionEvent __sessionEvent;

    public DefaultSession(IConnectionHolder connectionHolder) {
        this(JDBC.get(), connectionHolder);
    }

    public DefaultSession(IDatabase owner, IConnectionHolder connectionHolder) {
        this.__owner = owner;
        this.__id = UUIDUtils.UUID();
        this.__connectionHolder = connectionHolder;
        this.__dialect = connectionHolder.getDialect();
        this.__tablePrefix = connectionHolder.getDataSourceCfgMeta().getTablePrefix();
    }

    public IDatabase getOwner() {
        return this.__owner;
    }

    public String getId() {
        return this.__id;
    }

    @Override
    public IConnectionHolder getConnectionHolder() {
        return this.__connectionHolder;
    }

    public ISession setSessionEvent(ISessionEvent sessionEvent) {
        this.__sessionEvent = sessionEvent;
        return this;
    }

    public void close() {
        if (this.__connectionHolder != null && Transactions.get() == null) {
            this.__connectionHolder.release();
        }
    }

    @Override
    public <T> IResultSet<T> find(SQL sql, IResultSetHandler<T> handler) throws Exception {
        DefaultQueryOperator<T> _opt = new DefaultQueryOperator<T>(sql.getSQL(), this.__connectionHolder, handler);
        for (Object _param : sql.params().params()) {
            _opt.addParameter(_param);
        }
        SessionEventContext _eventContext = new SessionEventContext(_opt, Type.OPT.QUERY);
        if (this.__sessionEvent != null) {
            this.__sessionEvent.onQueryBefore(_eventContext);
        }
        _opt.execute();
        if (this.__sessionEvent != null) {
            this.__sessionEvent.onQueryAfter(_eventContext);
        }
        this.__owner.getOwner().getEvents().fireEvent(new DatabaseEvent(this.__owner, DatabaseEvent.EVENT.QUERY_AFTER).setEventSource(_eventContext));
        return new DefaultResultSet(_opt.getResultSet());
    }

    @Override
    public <T> IResultSet<T> find(SQL sql, IResultSetHandler<T> handler, Page page) throws Exception {
        String _selectSql = sql.getSQL();
        long _count = 0L;
        if (page != null) {
            _selectSql = this.__dialect.buildPagedQuerySQL(sql.getSQL(), page.page(), page.pageSize());
            if (page.isCount() && (_count = this.count(sql)) == 0L) {
                return new DefaultResultSet(new ArrayList(), page.page(), page.pageSize(), _count);
            }
        }
        DefaultQueryOperator<T> _opt = new DefaultQueryOperator<T>(_selectSql, this.__connectionHolder, handler);
        for (Object _param : sql.params().params()) {
            _opt.addParameter(_param);
        }
        SessionEventContext _eventContext = new SessionEventContext(_opt, Type.OPT.QUERY);
        if (this.__sessionEvent != null) {
            this.__sessionEvent.onQueryBefore(_eventContext);
        }
        _opt.execute();
        if (this.__sessionEvent != null) {
            this.__sessionEvent.onQueryAfter(_eventContext);
        }
        this.__owner.getOwner().getEvents().fireEvent(new DatabaseEvent(this.__owner, DatabaseEvent.EVENT.QUERY_AFTER).setEventSource(_eventContext));
        if (page != null) {
            return new DefaultResultSet(_opt.getResultSet(), page.page(), page.pageSize(), _count);
        }
        return new DefaultResultSet(_opt.getResultSet());
    }

    @Override
    public <T extends IEntity> IResultSet<T> find(T entity) throws Exception {
        return this.find(entity, Fields.create((String[])new String[0]), null, entity instanceof IShardingable ? (IShardingable)entity : null);
    }

    @Override
    public <T extends IEntity> IResultSet<T> find(T entity, IShardingable shardingable) throws Exception {
        return this.find(entity, Fields.create((String[])new String[0]), null, shardingable);
    }

    @Override
    public <T extends IEntity> IResultSet<T> find(T entity, Page page) throws Exception {
        return this.find(entity, Fields.create((String[])new String[0]), page, entity instanceof IShardingable ? (IShardingable)entity : null);
    }

    @Override
    public <T extends IEntity> IResultSet<T> find(T entity, Page page, IShardingable shardingable) throws Exception {
        return this.find(entity, Fields.create((String[])new String[0]), page, shardingable);
    }

    @Override
    public <T extends IEntity> IResultSet<T> find(T entity, Fields filter) throws Exception {
        return this.find(entity, filter, null, entity instanceof IShardingable ? (IShardingable)entity : null);
    }

    @Override
    public <T extends IEntity> IResultSet<T> find(T entity, Fields filter, IShardingable shardingable) throws Exception {
        return this.find(entity, filter, null, shardingable);
    }

    @Override
    public <T extends IEntity> IResultSet<T> find(T entity, Fields filter, Page page) throws Exception {
        return this.find(entity, filter, page, entity instanceof IShardingable ? (IShardingable)entity : null);
    }

    @Override
    public <T extends IEntity> IResultSet<T> find(T entity, Fields filter, Page page, IShardingable shardingable) throws Exception {
        return this.find(EntitySQL.create(entity.getClass()).field(filter), Where.create(BaseEntity.buildEntityCond(entity)), page, shardingable);
    }

    @Override
    public <T extends IEntity> IResultSet<T> find(EntitySQL<T> entity) throws Exception {
        return this.find(entity, null, null, null);
    }

    @Override
    public <T extends IEntity> IResultSet<T> find(EntitySQL<T> entity, IShardingable shardingable) throws Exception {
        return this.find(entity, null, null, shardingable);
    }

    @Override
    public <T extends IEntity> IResultSet<T> find(EntitySQL<T> entity, Page page) throws Exception {
        return this.find(entity, null, page, null);
    }

    @Override
    public <T extends IEntity> IResultSet<T> find(EntitySQL<T> entity, Page page, IShardingable shardingable) throws Exception {
        return this.find(entity, null, page, shardingable);
    }

    @Override
    public <T extends IEntity> IResultSet<T> find(EntitySQL<T> entity, Where where) throws Exception {
        return this.find(entity, where, null, null);
    }

    @Override
    public <T extends IEntity> IResultSet<T> find(EntitySQL<T> entity, Where where, IShardingable shardingable) throws Exception {
        return this.find(entity, where, null, shardingable);
    }

    @Override
    public <T extends IEntity> IResultSet<T> find(EntitySQL<T> entity, Where where, Page page) throws Exception {
        return this.find(entity, where, page, null);
    }

    @Override
    public <T extends IEntity> IResultSet<T> find(EntitySQL<T> entity, Where where, Page page, IShardingable shardingable) throws Exception {
        String _selectSql = this.__dialect.buildSelectSQL(entity.getEntityClass(), this.__tablePrefix, shardingable, this.__doGetNotExcludedFields(EntityMeta.createAndGet(entity.getEntityClass()), entity.fields(), false, true));
        if (where != null) {
            _selectSql = _selectSql.concat(" ").concat(where.toString());
        }
        long _count = 0L;
        if (page != null) {
            _selectSql = this.__dialect.buildPagedQuerySQL(_selectSql, page.page(), page.pageSize());
            if (page.isCount() && (_count = this.count(entity.getEntityClass(), where)) == 0L) {
                return new DefaultResultSet(new ArrayList(), page.page(), page.pageSize(), _count);
            }
        }
        if (entity.forUpdate() != null) {
            _selectSql = _selectSql + " " + entity.forUpdate().toSQL();
        }
        DefaultQueryOperator<T> _opt = new DefaultQueryOperator<T>(_selectSql, this.__connectionHolder, new EntityResultSetHandler<T>(entity.getEntityClass()));
        if (where != null) {
            for (Object _param : where.getParams().params()) {
                _opt.addParameter(_param);
            }
        }
        SessionEventContext _eventContext = new SessionEventContext(_opt, Type.OPT.QUERY);
        if (this.__sessionEvent != null) {
            this.__sessionEvent.onQueryBefore(_eventContext);
        }
        _opt.execute();
        if (this.__sessionEvent != null) {
            this.__sessionEvent.onQueryAfter(_eventContext);
        }
        this.__owner.getOwner().getEvents().fireEvent(new DatabaseEvent(this.__owner, DatabaseEvent.EVENT.QUERY_AFTER).setEventSource(_eventContext));
        if (page != null) {
            return new DefaultResultSet(_opt.getResultSet(), page.page(), page.pageSize(), _count);
        }
        return new DefaultResultSet(_opt.getResultSet());
    }

    @Override
    public <T extends IEntity> T find(EntitySQL<T> entity, Serializable id) throws Exception {
        return this.find(entity, id, null);
    }

    @Override
    public <T extends IEntity> T find(EntitySQL<T> entity, Serializable id, IShardingable shardingable) throws Exception {
        EntityMeta _meta = EntityMeta.createAndGet(entity.getEntityClass());
        PairObject<Fields, Params> _entityPK = this.__doGetPrimaryKeyFieldAndValues(_meta, id, null);
        String _selectSql = this.__dialect.buildSelectByPkSQL(entity.getEntityClass(), this.__tablePrefix, shardingable, (Fields)_entityPK.getKey(), this.__doGetNotExcludedFields(_meta, entity.fields(), false, true));
        if (entity.forUpdate() != null) {
            _selectSql = _selectSql + " " + entity.forUpdate().toSQL();
        }
        DefaultQueryOperator<T> _opt = new DefaultQueryOperator<T>(_selectSql, this.__connectionHolder, new EntityResultSetHandler<T>(entity.getEntityClass()));
        if (_meta.isMultiplePrimaryKey()) {
            for (Object _param : ((Params)_entityPK.getValue()).params()) {
                _opt.addParameter(_param);
            }
        } else {
            _opt.addParameter(id);
        }
        SessionEventContext _eventContext = new SessionEventContext(_opt, Type.OPT.QUERY);
        if (this.__sessionEvent != null) {
            this.__sessionEvent.onQueryBefore(_eventContext);
        }
        _opt.execute();
        if (this.__sessionEvent != null) {
            this.__sessionEvent.onQueryAfter(_eventContext);
        }
        this.__owner.getOwner().getEvents().fireEvent(new DatabaseEvent(this.__owner, DatabaseEvent.EVENT.QUERY_AFTER).setEventSource(_eventContext));
        return (T)(_opt.getResultSet().isEmpty() ? null : (IEntity)_opt.getResultSet().get(0));
    }

    @Override
    public <T> T findFirst(SQL sql, IResultSetHandler<T> handler) throws Exception {
        String _selectSql = this.__dialect.buildPagedQuerySQL(sql.getSQL(), 1, 1);
        DefaultQueryOperator<T> _opt = new DefaultQueryOperator<T>(_selectSql, this.__connectionHolder, handler);
        for (Object _param : sql.params().params()) {
            _opt.addParameter(_param);
        }
        SessionEventContext _eventContext = new SessionEventContext(_opt, Type.OPT.QUERY);
        if (this.__sessionEvent != null) {
            this.__sessionEvent.onQueryBefore(_eventContext);
        }
        _opt.execute();
        if (this.__sessionEvent != null) {
            this.__sessionEvent.onQueryAfter(_eventContext);
        }
        this.__owner.getOwner().getEvents().fireEvent(new DatabaseEvent(this.__owner, DatabaseEvent.EVENT.QUERY_AFTER).setEventSource(_eventContext));
        return _opt.getResultSet().isEmpty() ? null : (T)_opt.getResultSet().get(0);
    }

    @Override
    public <T extends IEntity> T findFirst(EntitySQL<T> entity) throws Exception {
        return this.findFirst(entity, null, null);
    }

    @Override
    public <T extends IEntity> T findFirst(EntitySQL<T> entity, IShardingable shardingable) throws Exception {
        return this.findFirst(entity, null, shardingable);
    }

    @Override
    public <T extends IEntity> T findFirst(EntitySQL<T> entity, Where where) throws Exception {
        return this.findFirst(entity, where, null);
    }

    @Override
    public <T extends IEntity> T findFirst(EntitySQL<T> entity, Where where, IShardingable shardingable) throws Exception {
        String _selectSql = this.__dialect.buildSelectSQL(entity.getEntityClass(), this.__tablePrefix, shardingable, this.__doGetNotExcludedFields(EntityMeta.createAndGet(entity.getEntityClass()), entity.fields(), false, true));
        if (where != null) {
            _selectSql = _selectSql.concat(" ").concat(where.toString());
        }
        _selectSql = this.__dialect.buildPagedQuerySQL(_selectSql, 1, 1);
        if (entity.forUpdate() != null) {
            _selectSql = _selectSql + " " + entity.forUpdate().toSQL();
        }
        DefaultQueryOperator<T> _opt = new DefaultQueryOperator<T>(_selectSql, this.__connectionHolder, new EntityResultSetHandler<T>(entity.getEntityClass()));
        if (where != null) {
            for (Object _param : where.getParams().params()) {
                _opt.addParameter(_param);
            }
        }
        SessionEventContext _eventContext = new SessionEventContext(_opt, Type.OPT.QUERY);
        if (this.__sessionEvent != null) {
            this.__sessionEvent.onQueryBefore(_eventContext);
        }
        _opt.execute();
        if (this.__sessionEvent != null) {
            this.__sessionEvent.onQueryAfter(_eventContext);
        }
        this.__owner.getOwner().getEvents().fireEvent(new DatabaseEvent(this.__owner, DatabaseEvent.EVENT.QUERY_AFTER).setEventSource(_eventContext));
        return (T)(_opt.getResultSet().isEmpty() ? null : (IEntity)_opt.getResultSet().get(0));
    }

    @Override
    public int executeForUpdate(SQL sql) throws Exception {
        DefaultUpdateOperator _opt = new DefaultUpdateOperator(sql.getSQL(), this.getConnectionHolder());
        for (Object _param : sql.params().params()) {
            _opt.addParameter(_param);
        }
        SessionEventContext _eventContext = new SessionEventContext((Object)_opt, Type.OPT.UPDATE);
        if (this.__sessionEvent != null) {
            this.__sessionEvent.onUpdateBefore(_eventContext);
        }
        _opt.execute();
        if (this.__sessionEvent != null) {
            this.__sessionEvent.onUpdateAfter(_eventContext);
        }
        this.__owner.getOwner().getEvents().fireEvent(new DatabaseEvent(this.__owner, DatabaseEvent.EVENT.UPDATE_AFTER).setEventSource(_eventContext));
        return _opt.getEffectCounts();
    }

    @Override
    public int[] executeForUpdate(BatchSQL sql) throws Exception {
        BatchUpdateOperator _opt;
        if (sql.getSQL() != null) {
            _opt = new BatchUpdateOperator(sql.getSQL(), this.getConnectionHolder());
            for (Params _param : sql.params()) {
                SQLBatchParameter _batchParam = SQLBatchParameter.create();
                for (Object _p : _param.params()) {
                    _batchParam.addParameter(_p);
                }
                _opt.addBatchParameter(_batchParam);
            }
        } else {
            _opt = new BatchUpdateOperator(this.getConnectionHolder());
        }
        for (String _sql : sql.getSQLs()) {
            _opt.addBatchSQL(_sql);
        }
        SessionEventContext _eventContext = new SessionEventContext((Object)_opt, Type.OPT.BATCH_UPDATE);
        if (this.__sessionEvent != null) {
            this.__sessionEvent.onUpdateBefore(_eventContext);
        }
        _opt.execute();
        if (this.__sessionEvent != null) {
            this.__sessionEvent.onUpdateAfter(_eventContext);
        }
        this.__owner.getOwner().getEvents().fireEvent(new DatabaseEvent(this.__owner, DatabaseEvent.EVENT.UPDATE_AFTER).setEventSource(_eventContext));
        return _opt.getEffectCounts();
    }

    @Override
    public <T extends IEntity> T update(T entity, Fields filter) throws Exception {
        return this.update(entity, filter, entity instanceof IShardingable ? (IShardingable)entity : null);
    }

    @Override
    public <T extends IEntity> T update(T entity, Fields filter, IShardingable shardingable) throws Exception {
        EntityMeta _meta = EntityMeta.createAndGet(entity.getClass());
        if (_meta.isView()) {
            throw new UnsupportedOperationException("View does not support this operation.");
        }
        PairObject<Fields, Params> _entity = this.__doGetPrimaryKeyFieldAndValues(_meta, entity, null);
        filter = this.__doGetNotExcludedFields(_meta, filter, true, false);
        String _updateSql = this.__dialect.buildUpdateByPkSQL(entity.getClass(), this.__tablePrefix, shardingable, (Fields)_entity.getKey(), filter);
        DefaultUpdateOperator _opt = new DefaultUpdateOperator(_updateSql, this.__connectionHolder);
        for (Object _param : ((Params)this.__doGetEntityFieldAndValues(_meta, entity, filter, false).getValue()).params()) {
            _opt.addParameter(_param);
        }
        for (Object _param : ((Params)_entity.getValue()).params()) {
            _opt.addParameter(_param);
        }
        SessionEventContext _eventContext = new SessionEventContext((Object)_opt, Type.OPT.UPDATE);
        if (this.__sessionEvent != null) {
            this.__sessionEvent.onUpdateBefore(_eventContext);
        }
        _opt.execute();
        if (this.__sessionEvent != null) {
            this.__sessionEvent.onUpdateAfter(_eventContext);
        }
        this.__owner.getOwner().getEvents().fireEvent(new DatabaseEvent(this.__owner, DatabaseEvent.EVENT.UPDATE_AFTER).setEventSource(_eventContext));
        if (_opt.getEffectCounts() > 0) {
            return entity;
        }
        return null;
    }

    @Override
    public <T extends IEntity> List<T> update(List<T> entities, Fields filter) throws Exception {
        IEntity _element = (IEntity)entities.get(0);
        EntityMeta _meta = EntityMeta.createAndGet(_element.getClass());
        if (_meta.isView()) {
            throw new UnsupportedOperationException("View does not support this operation.");
        }
        PairObject<Fields, Params> _entity = this.__doGetPrimaryKeyFieldAndValues(_meta, _element, null);
        filter = this.__doGetNotExcludedFields(_meta, filter, true, false);
        String _updateSql = this.__dialect.buildUpdateByPkSQL(_element.getClass(), this.__tablePrefix, null, (Fields)_entity.getKey(), filter);
        BatchUpdateOperator _opt = new BatchUpdateOperator(_updateSql, this.__connectionHolder);
        for (IEntity entity : entities) {
            SQLBatchParameter _batchParam = SQLBatchParameter.create();
            _entity = this.__doGetEntityFieldAndValues(_meta, entity, filter, false);
            for (Object _param : ((Params)_entity.getValue()).params()) {
                _batchParam.addParameter(_param);
            }
            _entity = this.__doGetPrimaryKeyFieldAndValues(_meta, entity, null);
            for (Object _param : ((Params)_entity.getValue()).params()) {
                _batchParam.addParameter(_param);
            }
            _opt.addBatchParameter(_batchParam);
        }
        SessionEventContext _eventContext = new SessionEventContext((Object)_opt, Type.OPT.BATCH_UPDATE);
        if (this.__sessionEvent != null) {
            this.__sessionEvent.onUpdateBefore(_eventContext);
        }
        _opt.execute();
        if (this.__sessionEvent != null) {
            this.__sessionEvent.onUpdateAfter(_eventContext);
        }
        this.__owner.getOwner().getEvents().fireEvent(new DatabaseEvent(this.__owner, DatabaseEvent.EVENT.UPDATE_AFTER).setEventSource(_eventContext));
        return entities;
    }

    @Override
    public <T extends IEntity> List<T> update(ShardingList<T> entities, Fields filter) throws Exception {
        ArrayList<IEntity> _results = new ArrayList<IEntity>();
        for (ShardingList.ShardingElement _element : entities) {
            IEntity _entity = this.update((IEntity)_element.getElement(), filter, (IShardingable)_element);
            if (_entity == null) continue;
            _results.add(_entity);
        }
        return _results;
    }

    @Override
    public <T extends IEntity> T insert(T entity) throws Exception {
        return this.insert(entity, null, entity instanceof IShardingable ? (IShardingable)entity : null);
    }

    @Override
    public <T extends IEntity> T insert(T entity, IShardingable shardingable) throws Exception {
        return this.insert(entity, null, shardingable);
    }

    @Override
    public <T extends IEntity> T insert(T entity, Fields filter) throws Exception {
        return this.insert(entity, filter, entity instanceof IShardingable ? (IShardingable)entity : null);
    }

    @Override
    public <T extends IEntity> T insert(T entity, Fields filter, IShardingable shardingable) throws Exception {
        EntityMeta _meta = EntityMeta.createAndGet(entity.getClass());
        if (_meta.isView()) {
            throw new UnsupportedOperationException("View does not support this operation.");
        }
        PairObject<Fields, Params> _entity = this.__doGetEntityFieldAndValues(_meta, entity, filter, true);
        String _insertSql = this.__dialect.buildInsertSQL(entity.getClass(), this.__tablePrefix, shardingable, (Fields)_entity.getKey());
        DefaultUpdateOperator _opt = new DefaultUpdateOperator(_insertSql, this.__connectionHolder);
        if (_meta.hasAutoincrement()) {
            if (this.__connectionHolder.getDialect() instanceof OracleDialect) {
                final String[] _ids = _meta.getAutoincrementKeys().toArray(new String[0]);
                _opt.setAccessorConfig(new EntityAccessorConfig(_meta, this.__connectionHolder, new IEntity[]{entity}){

                    @Override
                    public PreparedStatement getPreparedStatement(Connection conn, String sql) throws SQLException {
                        if (conn != null && !conn.isClosed()) {
                            return conn.prepareStatement(sql, _ids);
                        }
                        return this.__conn.getConnection().prepareStatement(sql, _ids);
                    }
                });
            } else {
                _opt.setAccessorConfig(new EntityAccessorConfig(_meta, this.__connectionHolder, entity));
            }
        }
        for (Object _param : ((Params)_entity.getValue()).params()) {
            _opt.addParameter(_param);
        }
        SessionEventContext _eventContext = new SessionEventContext((Object)_opt, Type.OPT.UPDATE);
        if (this.__sessionEvent != null) {
            this.__sessionEvent.onInsertBefore(_eventContext);
        }
        _opt.execute();
        if (this.__sessionEvent != null) {
            this.__sessionEvent.onInsertAfter(_eventContext);
        }
        this.__owner.getOwner().getEvents().fireEvent(new DatabaseEvent(this.__owner, DatabaseEvent.EVENT.INSERT_AFTER).setEventSource(_eventContext));
        if (_opt.getEffectCounts() > 0) {
            return entity;
        }
        return null;
    }

    @Override
    public <T extends IEntity> List<T> insert(List<T> entities) throws Exception {
        return this.insert(entities, null);
    }

    @Override
    public <T extends IEntity> List<T> insert(ShardingList<T> entities) throws Exception {
        return this.insert(entities, null);
    }

    @Override
    public <T extends IEntity> List<T> insert(List<T> entities, Fields filter) throws Exception {
        IEntity<?> _element = entities.get(0);
        EntityMeta _meta = EntityMeta.createAndGet(_element.getClass());
        if (_meta.isView()) {
            throw new UnsupportedOperationException("View does not support this operation.");
        }
        PairObject<Fields, Params> _entity = this.__doGetEntityFieldAndValues(_meta, _element, filter, true);
        String _insertSql = this.__dialect.buildInsertSQL(_element.getClass(), this.__tablePrefix, null, (Fields)_entity.getKey());
        BatchUpdateOperator _opt = new BatchUpdateOperator(_insertSql, this.__connectionHolder);
        if (_meta.hasAutoincrement()) {
            if (this.__connectionHolder.getDialect() instanceof OracleDialect) {
                final String[] _ids = _meta.getAutoincrementKeys().toArray(new String[0]);
                _opt.setAccessorConfig(new EntityAccessorConfig(_meta, this.__connectionHolder, entities){

                    @Override
                    public PreparedStatement getPreparedStatement(Connection conn, String sql) throws SQLException {
                        if (conn != null && !conn.isClosed()) {
                            return conn.prepareStatement(sql, _ids);
                        }
                        return this.__conn.getConnection().prepareStatement(sql, _ids);
                    }
                });
            } else {
                _opt.setAccessorConfig(new EntityAccessorConfig(_meta, this.__connectionHolder, entities));
            }
        }
        for (IEntity<?> iEntity : entities) {
            SQLBatchParameter _batchParam = SQLBatchParameter.create();
            for (Object _param : ((Params)this.__doGetEntityFieldAndValues(_meta, iEntity, filter, true).getValue()).params()) {
                _batchParam.addParameter(_param);
            }
            _opt.addBatchParameter(_batchParam);
        }
        SessionEventContext _eventContext = new SessionEventContext((Object)_opt, Type.OPT.BATCH_UPDATE);
        if (this.__sessionEvent != null) {
            this.__sessionEvent.onInsertBefore(_eventContext);
        }
        _opt.execute();
        if (this.__sessionEvent != null) {
            this.__sessionEvent.onInsertAfter(_eventContext);
        }
        this.__owner.getOwner().getEvents().fireEvent(new DatabaseEvent(this.__owner, DatabaseEvent.EVENT.INSERT_AFTER).setEventSource(_eventContext));
        return entities;
    }

    @Override
    public <T extends IEntity> List<T> insert(ShardingList<T> entities, Fields filter) throws Exception {
        ArrayList<IEntity> _results = new ArrayList<IEntity>();
        for (ShardingList.ShardingElement _element : entities) {
            IEntity _entity = this.insert((IEntity)_element.getElement(), filter, (IShardingable)_element);
            if (_entity == null) continue;
            _results.add(_entity);
        }
        return _results;
    }

    @Override
    public <T extends IEntity> T delete(T entity) throws Exception {
        return this.delete(entity, entity instanceof IShardingable ? (IShardingable)entity : null);
    }

    @Override
    public <T extends IEntity> T delete(T entity, IShardingable shardingable) throws Exception {
        if (this.delete(entity.getClass(), entity.getId(), shardingable) > 0) {
            return entity;
        }
        return null;
    }

    @Override
    public <T extends IEntity> int delete(Class<T> entityClass, Serializable id) throws Exception {
        return this.delete(entityClass, id, null);
    }

    @Override
    public <T extends IEntity> int delete(Class<T> entityClass, Serializable id, IShardingable shardingable) throws Exception {
        EntityMeta _meta = EntityMeta.createAndGet(entityClass);
        if (_meta.isView()) {
            throw new UnsupportedOperationException("View does not support this operation.");
        }
        PairObject<Fields, Params> _entity = this.__doGetPrimaryKeyFieldAndValues(_meta, id, null);
        String _deleteSql = this.__dialect.buildDeleteByPkSQL(entityClass, this.__tablePrefix, shardingable, (Fields)_entity.getKey());
        DefaultUpdateOperator _opt = new DefaultUpdateOperator(_deleteSql, this.__connectionHolder);
        for (Object _param : ((Params)_entity.getValue()).params()) {
            _opt.addParameter(_param);
        }
        SessionEventContext _eventContext = new SessionEventContext((Object)_opt, Type.OPT.UPDATE);
        if (this.__sessionEvent != null) {
            this.__sessionEvent.onRemoveBefore(_eventContext);
        }
        _opt.execute();
        if (this.__sessionEvent != null) {
            this.__sessionEvent.onRemoveAfter(_eventContext);
        }
        this.__owner.getOwner().getEvents().fireEvent(new DatabaseEvent(this.__owner, DatabaseEvent.EVENT.REMOVE_AFTER).setEventSource(_eventContext));
        return _opt.getEffectCounts();
    }

    @Override
    public <T extends IEntity> List<T> delete(List<T> entities) throws Exception {
        EntityMeta _meta = EntityMeta.createAndGet(((IEntity)entities.get(0)).getClass());
        if (_meta.isView()) {
            throw new UnsupportedOperationException("View does not support this operation.");
        }
        PairObject<Fields, Params> _entity = this.__doGetPrimaryKeyFieldAndValues(_meta, entities.get(0), null);
        String _deleteSql = this.__dialect.buildDeleteByPkSQL(((IEntity)entities.get(0)).getClass(), this.__tablePrefix, null, (Fields)_entity.getKey());
        BatchUpdateOperator _opt = new BatchUpdateOperator(_deleteSql, this.__connectionHolder);
        for (IEntity entity : entities) {
            SQLBatchParameter _batchParam = SQLBatchParameter.create();
            _entity = this.__doGetPrimaryKeyFieldAndValues(_meta, entity, null);
            for (Object _param : ((Params)_entity.getValue()).params()) {
                _batchParam.addParameter(_param);
            }
            _opt.addBatchParameter(_batchParam);
        }
        SessionEventContext _eventContext = new SessionEventContext((Object)_opt, Type.OPT.BATCH_UPDATE);
        if (this.__sessionEvent != null) {
            this.__sessionEvent.onRemoveBefore(_eventContext);
        }
        _opt.execute();
        if (this.__sessionEvent != null) {
            this.__sessionEvent.onRemoveAfter(_eventContext);
        }
        this.__owner.getOwner().getEvents().fireEvent(new DatabaseEvent(this.__owner, DatabaseEvent.EVENT.REMOVE_AFTER).setEventSource(_eventContext));
        return entities;
    }

    @Override
    public <T extends IEntity> List<T> delete(ShardingList<T> entities) throws Exception {
        ArrayList<IEntity> _results = new ArrayList<IEntity>();
        for (ShardingList.ShardingElement _element : entities) {
            IEntity _entity = this.delete((IEntity)_element.getElement(), (IShardingable)_element);
            if (_entity == null) continue;
            _results.add(_entity);
        }
        return _results;
    }

    @Override
    public <T extends IEntity> int[] delete(Class<T> entityClass, Serializable[] ids) throws Exception {
        EntityMeta _meta = EntityMeta.createAndGet(entityClass);
        if (_meta.isView()) {
            throw new UnsupportedOperationException("View does not support this operation.");
        }
        PairObject<Fields, Params> _entity = this.__doGetPrimaryKeyFieldAndValues(_meta, ids[0], null);
        String _deleteSql = this.__dialect.buildDeleteByPkSQL(entityClass, this.__tablePrefix, null, (Fields)_entity.getKey());
        BatchUpdateOperator _opt = new BatchUpdateOperator(_deleteSql, this.__connectionHolder);
        for (Serializable _id : ids) {
            SQLBatchParameter _batchParam = SQLBatchParameter.create();
            _entity = this.__doGetPrimaryKeyFieldAndValues(_meta, _id, null);
            for (Object _param : ((Params)_entity.getValue()).params()) {
                _batchParam.addParameter(_param);
            }
            _opt.addBatchParameter(_batchParam);
        }
        SessionEventContext _eventContext = new SessionEventContext((Object)_opt, Type.OPT.BATCH_UPDATE);
        if (this.__sessionEvent != null) {
            this.__sessionEvent.onRemoveBefore(_eventContext);
        }
        _opt.execute();
        if (this.__sessionEvent != null) {
            this.__sessionEvent.onRemoveAfter(_eventContext);
        }
        this.__owner.getOwner().getEvents().fireEvent(new DatabaseEvent(this.__owner, DatabaseEvent.EVENT.REMOVE_AFTER).setEventSource(_eventContext));
        return _opt.getEffectCounts();
    }

    @Override
    public <T extends IEntity> int[] delete(Class<T> entityClass, ShardingList<Serializable> ids) throws Exception {
        ArrayList<Integer> _results = new ArrayList<Integer>();
        for (ShardingList.ShardingElement _element : ids) {
            _results.add(this.delete(entityClass, (Serializable)_element.getElement(), (IShardingable)_element));
        }
        return ArrayUtils.toPrimitive((Integer[])_results.toArray(new Integer[0]));
    }

    @Override
    public <T extends IEntity> long count(Class<T> entityClass, Where where) throws Exception {
        return this.count(entityClass, where, null);
    }

    @Override
    public <T extends IEntity> long count(Class<T> entityClass) throws Exception {
        return this.count(entityClass, null, null);
    }

    @Override
    public <T extends IEntity> long count(Class<T> entityClass, Where where, IShardingable shardingable) throws Exception {
        EntityMeta _meta = EntityMeta.createAndGet(entityClass);
        ExpressionUtils _exp = ExpressionUtils.bind((String)"SELECT count(*) FROM ${table_name} ${where}").set("table_name", this.__dialect.buildTableName(this.__tablePrefix, _meta, shardingable)).set("where", where == null ? "" : where.toSQL());
        DefaultQueryOperator<Object[]> _opt = new DefaultQueryOperator<Object[]>(_exp.getResult(), this.getConnectionHolder(), new ArrayResultSetHandler());
        if (where != null) {
            for (Object _param : where.getParams().params()) {
                _opt.addParameter(_param);
            }
        }
        SessionEventContext _eventContext = new SessionEventContext(_opt, Type.OPT.QUERY);
        if (this.__sessionEvent != null) {
            this.__sessionEvent.onQueryBefore(_eventContext);
        }
        _opt.execute();
        if (this.__sessionEvent != null) {
            this.__sessionEvent.onQueryAfter(_eventContext);
        }
        this.__owner.getOwner().getEvents().fireEvent(new DatabaseEvent(this.__owner, DatabaseEvent.EVENT.QUERY_AFTER).setEventSource(_eventContext));
        return BlurObject.bind((Object)((Object[])((Object[])_opt.getResultSet().get(0))[0])[1]).toLongValue();
    }

    @Override
    public long count(SQL sql) throws Exception {
        String _sql = this.__dialect.buildCountSQL(sql.getSQL());
        DefaultQueryOperator<Object[]> _opt = new DefaultQueryOperator<Object[]>(_sql, this.getConnectionHolder(), new ArrayResultSetHandler());
        for (Object _param : sql.params().params()) {
            _opt.addParameter(_param);
        }
        SessionEventContext _eventContext = new SessionEventContext(_opt, Type.OPT.QUERY);
        if (this.__sessionEvent != null) {
            this.__sessionEvent.onQueryBefore(_eventContext);
        }
        _opt.execute();
        if (this.__sessionEvent != null) {
            this.__sessionEvent.onQueryAfter(_eventContext);
        }
        this.__owner.getOwner().getEvents().fireEvent(new DatabaseEvent(this.__owner, DatabaseEvent.EVENT.QUERY_AFTER).setEventSource(_eventContext));
        return BlurObject.bind((Object)((Object[])((Object[])_opt.getResultSet().get(0))[0])[1]).toLongValue();
    }

    private PairObject<Fields, Params> __doGetPrimaryKeyFieldAndValues(EntityMeta entityMeta, Object targetObj, Fields filter) throws Exception {
        Fields _fields = Fields.create((String[])new String[0]);
        Params _values = Params.create((Object[])new Object[0]);
        if (targetObj instanceof IEntityPK) {
            if (entityMeta.isMultiplePrimaryKey()) {
                for (String _pkFieldName : entityMeta.getPrimaryKeys()) {
                    Object _value = entityMeta.getPropertyByName(_pkFieldName).getField().get(targetObj);
                    if (_value == null || !this.__doCheckField(filter, _pkFieldName)) continue;
                    _fields.add(_pkFieldName);
                    _values.add(_value);
                }
            } else {
                String _fieldName = (String)entityMeta.getPrimaryKeys().get(0);
                if (this.__doCheckField(filter, _fieldName)) {
                    _fields.add(_fieldName);
                    _values.add(targetObj);
                }
            }
        } else if (targetObj instanceof IEntity) {
            if (entityMeta.isMultiplePrimaryKey()) {
                PairObject<Fields, Params> _tmpValues = this.__doGetPrimaryKeyFieldAndValues(entityMeta, ((IEntity)targetObj).getId(), filter);
                _fields.add((Fields)_tmpValues.getKey());
                _values.add((Params)_tmpValues.getValue());
            } else {
                String _fieldName = (String)entityMeta.getPrimaryKeys().get(0);
                if (this.__doCheckField(filter, _fieldName)) {
                    _fields.add(_fieldName);
                    _values.add((Object)((IEntity)targetObj).getId());
                }
            }
        } else {
            String _fieldName = (String)entityMeta.getPrimaryKeys().get(0);
            if (this.__doCheckField(filter, _fieldName)) {
                _fields.add(_fieldName);
                _values.add(targetObj);
            }
        }
        return new PairObject((Object)_fields, (Object)_values);
    }

    private PairObject<Fields, Params> __doGetEntityFieldAndValues(EntityMeta entityMeta, IEntity targetObj, Fields filter, boolean includePK) throws Exception {
        Fields _fields = Fields.create((String[])new String[0]);
        Params _values = Params.create((Object[])new Object[0]);
        for (String _fieldName : entityMeta.getPropertyNames()) {
            if (!this.__doCheckField(filter, _fieldName)) continue;
            EntityMeta.PropertyMeta _propMeta = entityMeta.getPropertyByName(_fieldName);
            Object _value = null;
            if (entityMeta.isPrimaryKey(_fieldName)) {
                if (includePK) {
                    if (_propMeta.isAutoincrement()) {
                        if (StringUtils.isNotBlank((String)_propMeta.getSequenceName())) {
                            _fields.add(_fieldName);
                            this.__dialect.getSequenceNextValSql(_propMeta.getSequenceName());
                        }
                    } else {
                        _value = entityMeta.isMultiplePrimaryKey() ? _propMeta.getField().get(targetObj.getId()) : targetObj.getId();
                    }
                }
            } else {
                _value = _propMeta.getField().get(targetObj);
            }
            if (_value == null) {
                _value = BlurObject.bind((Object)_propMeta.getDefaultValue()).toObjectValue(_propMeta.getField().getType());
            }
            if (_value != null || _propMeta.isNullable()) {
                if (includePK && entityMeta.isPrimaryKey(_fieldName) && entityMeta.isAutoincrement(_fieldName)) continue;
                _fields.add(_fieldName);
                _values.add(_value);
                continue;
            }
            if (_propMeta.isAutoincrement() || _propMeta.isNullable()) continue;
            throw new IllegalArgumentException(String.format("Entity field '%s.%s' value can not be null.", entityMeta.getEntityName(), _propMeta.getName()));
        }
        return new PairObject((Object)_fields, (Object)_values);
    }

    private boolean __doCheckField(Fields filter, String fieldName) {
        if (filter != null && !filter.fields().isEmpty()) {
            if (filter.isExcluded()) {
                return !filter.fields().contains(fieldName);
            }
            return filter.fields().contains(fieldName);
        }
        return true;
    }

    private Fields __doGetNotExcludedFields(EntityMeta entityMeta, Fields filter, boolean forUpdate, boolean includePK) {
        Fields _returnValue = Fields.create((String[])new String[0]);
        for (String _field : entityMeta.getPropertyNames()) {
            if (!this.__doCheckField(filter, _field) || !includePK && entityMeta.isPrimaryKey(_field) || forUpdate && entityMeta.isReadonly(_field)) continue;
            _returnValue.add(_field);
        }
        return _returnValue;
    }

    private class EntityAccessorConfig
    implements IAccessorConfig {
        EntityMeta __entityMeta;
        final IConnectionHolder __conn;
        List<IEntity<?>> __entities;

        EntityAccessorConfig(EntityMeta entityMeta, IConnectionHolder connectionHolder, IEntity<?> ... entity) {
            this.__entityMeta = entityMeta;
            this.__conn = connectionHolder;
            this.__entities = Arrays.asList(entity);
        }

        EntityAccessorConfig(EntityMeta entityMeta, IConnectionHolder connectionHolder, List<IEntity<?>> entities) {
            this.__entityMeta = entityMeta;
            this.__conn = connectionHolder;
            this.__entities = entities;
        }

        @Override
        public Statement getStatement(Connection conn) throws Exception {
            if (conn != null && !conn.isClosed()) {
                return conn.createStatement();
            }
            return this.__conn.getConnection().createStatement();
        }

        @Override
        public CallableStatement getCallableStatement(Connection conn, String sql) throws Exception {
            if (conn != null && !conn.isClosed()) {
                return conn.prepareCall(sql);
            }
            return this.__conn.getConnection().prepareCall(sql);
        }

        @Override
        public PreparedStatement getPreparedStatement(Connection conn, String sql) throws Exception {
            if (conn != null && !conn.isClosed()) {
                return conn.prepareStatement(sql, 1);
            }
            return this.__conn.getConnection().prepareStatement(sql, 1);
        }

        @Override
        public void beforeStatementExecution(AccessorEventContext context) throws Exception {
        }

        @Override
        public void afterStatementExecution(AccessorEventContext context) throws Exception {
            Map<String, Object> _keyValues;
            if (this.__entities != null && this.__entityMeta.hasAutoincrement() && !(_keyValues = DefaultSession.this.__dialect.getGeneratedKey(context.getStatement(), this.__entityMeta.getAutoincrementKeys())).isEmpty()) {
                for (IEntity<?> _entity : this.__entities) {
                    for (Map.Entry<String, Object> _autoField : _keyValues.entrySet()) {
                        Field _field = this.__entityMeta.getPropertyByName(_autoField.getKey()).getField();
                        if (_autoField.getValue() == null) continue;
                        if (this.__entityMeta.isMultiplePrimaryKey()) {
                            _field.set(_entity.getId(), BlurObject.bind((Object)_autoField.getValue()).toObjectValue(_field.getType()));
                            continue;
                        }
                        _field.set(_entity, BlurObject.bind((Object)_autoField.getValue()).toObjectValue(_field.getType()));
                    }
                }
            }
        }

        @Override
        public int getFetchDirection() {
            return 0;
        }

        @Override
        public int getFetchSize() {
            return 10000;
        }

        @Override
        public int getMaxFieldSize() {
            return 0;
        }

        @Override
        public int getMaxRows() {
            return 1000;
        }

        @Override
        public int getQueryTimeout() {
            return 0;
        }
    }
}

