/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.platform.persistence.jdbc.impl;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.ymate.platform.core.YMP;
import net.ymate.platform.core.support.IConfigReader;
import net.ymate.platform.core.support.impl.MapSafeConfigReader;
import net.ymate.platform.core.util.ClassUtils;
import net.ymate.platform.core.util.RuntimeUtils;
import net.ymate.platform.persistence.jdbc.DataSourceCfgMeta;
import net.ymate.platform.persistence.jdbc.IDatabaseModuleCfg;
import net.ymate.platform.persistence.jdbc.JDBC;
import org.apache.commons.lang.StringUtils;

public class DefaultDatabaseModuleCfg
implements IDatabaseModuleCfg {
    private final YMP owner;
    private final String dataSourceDefaultName;
    private final Map<String, DataSourceCfgMeta> dataSourceCfgMetas;

    public DefaultDatabaseModuleCfg(YMP owner) throws Exception {
        this.owner = owner;
        IConfigReader _moduleCfg = MapSafeConfigReader.bind((Map)owner.getConfig().getModuleConfigs("persistence.jdbc"));
        this.dataSourceDefaultName = _moduleCfg.getString("ds_default_name", "default");
        this.dataSourceCfgMetas = new HashMap<String, DataSourceCfgMeta>();
        String _dsNameStr = _moduleCfg.getString("ds_name_list", "default");
        if (StringUtils.contains((String)_dsNameStr, (String)this.dataSourceDefaultName)) {
            String[] _dsNameList;
            for (String _dsName : _dsNameList = StringUtils.split((String)_dsNameStr, (String)"|")) {
                DataSourceCfgMeta _meta = this.__doParserDataSourceCfgMeta(_dsName, _moduleCfg.getMap("ds." + _dsName + "."));
                if (_meta == null) continue;
                this.dataSourceCfgMetas.put(_dsName, _meta);
            }
        } else {
            throw new IllegalArgumentException("The default datasource name does not match");
        }
    }

    private DataSourceCfgMeta __doParserDataSourceCfgMeta(String dsName, Map<String, String> dataSourceCfgs) throws Exception {
        if (!dataSourceCfgs.isEmpty()) {
            IConfigReader _dataSourceCfg = MapSafeConfigReader.bind(dataSourceCfgs);
            DataSourceCfgMeta _meta = new DataSourceCfgMeta();
            _meta.setName(dsName);
            _meta.setConnectionUrl(RuntimeUtils.replaceEnvVariable((String)_dataSourceCfg.getString("connection_url")));
            _meta.setUsername(_dataSourceCfg.getString("username"));
            if (StringUtils.isNotBlank((String)_meta.getConnectionUrl()) && StringUtils.isNotBlank((String)_meta.getUsername())) {
                block6: {
                    _meta.setIsShowSQL(_dataSourceCfg.getBoolean("show_sql"));
                    _meta.setIsStackTraces(_dataSourceCfg.getBoolean("stack_traces"));
                    _meta.setStackTraceDepth(_dataSourceCfg.getInt("stack_trace_depth"));
                    _meta.setStackTracePackage(_dataSourceCfg.getString("stack_trace_package"));
                    _meta.setTablePrefix(_dataSourceCfg.getString("table_prefix"));
                    _meta.setIdentifierQuote(_dataSourceCfg.getString("identifier_quote"));
                    String _adapterClassName = _dataSourceCfg.getString("adapter_class", "default");
                    _adapterClassName = StringUtils.defaultIfBlank((String)JDBC.DS_ADAPTERS.get(_adapterClassName), (String)_adapterClassName);
                    _meta.setAdapterClass(ClassUtils.loadClass((String)_adapterClassName, this.getClass()));
                    try {
                        _meta.setType(JDBC.DATABASE.valueOf(StringUtils.trimToEmpty((String)_dataSourceCfg.getString("type")).toUpperCase()));
                    }
                    catch (IllegalArgumentException e) {
                        String _connUrl = URI.create(_meta.getConnectionUrl()).toString();
                        String[] _type = StringUtils.split((String)_connUrl, (String)":");
                        if (_type == null || _type.length <= 0) break block6;
                        if ("microsoft".equals(_type[1])) {
                            _meta.setType(JDBC.DATABASE.SQLSERVER);
                        }
                        _meta.setType(JDBC.DATABASE.valueOf(_type[1].toUpperCase()));
                    }
                }
                _meta.setDialectClass(_dataSourceCfg.getString("dialect_class"));
                _meta.setDriverClass(_dataSourceCfg.getString("driver_class", JDBC.DB_DRIVERS.get((Object)_meta.getType())));
                _meta.setPassword(_dataSourceCfg.getString("password"));
                _meta.setIsPasswordEncrypted(_dataSourceCfg.getBoolean("password_encrypted"));
                String _passwordClass = _dataSourceCfg.getString("password_class");
                if (_meta.isPasswordEncrypted() && StringUtils.isNotBlank((String)_meta.getPassword()) && StringUtils.isNotBlank((String)_passwordClass) && !StringUtils.equals((String)this.owner.getConfig().getDefaultPasswordClass().getName(), (String)_passwordClass)) {
                    _meta.setPasswordClass(ClassUtils.loadClass((String)_passwordClass, this.getClass()));
                }
                return _meta;
            }
        }
        return null;
    }

    @Override
    public String getDataSourceDefaultName() {
        return this.dataSourceDefaultName;
    }

    @Override
    public Map<String, DataSourceCfgMeta> getDataSourceCfgs() {
        return Collections.unmodifiableMap(this.dataSourceCfgMetas);
    }

    @Override
    public DataSourceCfgMeta getDefaultDataSourceCfg() {
        return this.dataSourceCfgMetas.get(this.dataSourceDefaultName);
    }

    @Override
    public DataSourceCfgMeta getDataSourceCfg(String name) {
        return this.dataSourceCfgMetas.get(name);
    }
}

