/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.platform.persistence.jdbc.dialect.impl;

import java.util.Collection;
import net.ymate.platform.core.util.ExpressionUtils;
import net.ymate.platform.persistence.Fields;
import net.ymate.platform.persistence.IShardingable;
import net.ymate.platform.persistence.base.EntityMeta;
import net.ymate.platform.persistence.base.IEntity;
import net.ymate.platform.persistence.jdbc.JDBC;
import net.ymate.platform.persistence.jdbc.dialect.AbstractDialect;
import org.apache.commons.lang.StringUtils;

public class OracleDialect
extends AbstractDialect {
    @Override
    public String getName() {
        return JDBC.DATABASE.ORACLE.name();
    }

    @Override
    public String getSequenceNextValSql(String sequenceName) {
        return sequenceName.concat(".nextval");
    }

    @Override
    public String buildInsertSQL(Class<? extends IEntity> entityClass, String prefix, IShardingable shardingable, Fields fields) {
        EntityMeta _meta = EntityMeta.createAndGet(entityClass);
        ExpressionUtils _exp = ExpressionUtils.bind((String)"INSERT INTO ${table_name} (${fields}) VALUES (${values})").set("table_name", this.buildTableName(prefix, _meta, shardingable));
        Fields _fields = Fields.create((String[])new String[0]);
        Fields _values = Fields.create((String[])new String[0]);
        for (String _fieldName : fields == null || fields.fields().isEmpty() ? _meta.getPropertyNames() : fields.fields()) {
            EntityMeta.PropertyMeta _propMeta = _meta.getPropertyByName(_fieldName);
            if (_propMeta.isAutoincrement()) {
                if (!StringUtils.isNotBlank((String)_propMeta.getSequenceName())) continue;
                _fields.add(_fieldName);
                _values.add(this.getSequenceNextValSql(_propMeta.getSequenceName()));
                continue;
            }
            _fields.add(_fieldName);
            _values.add("?");
        }
        this.__doValidProperty(_meta, _fields, false);
        return _exp.set("fields", this.__doGenerateFieldsFormatStr(_fields, null, null)).set("values", StringUtils.join((Collection)_values.fields(), (String)", ")).getResult();
    }

    @Override
    public String buildPagedQuerySQL(String originSql, int page, int pageSize) {
        StringBuilder _returnValue = new StringBuilder(originSql.length() + 100);
        int _limit = (page - 1) * pageSize;
        if (pageSize == 0) {
            _returnValue.append("SELECT * FROM ( ").append(originSql).append(" ) WHERE rownum <= ").append(Integer.toString(_limit));
        } else {
            _returnValue.append("SELECT * FROM ( SELECT row_.*, rownum rownum_ FROM ( ").append(originSql);
            _returnValue.append(" ) row_ ) WHERE rownum_ > ").append(Integer.toString(_limit)).append(" AND rownum_ <= ").append(Integer.toString(_limit + pageSize));
        }
        return _returnValue.toString();
    }
}

