/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.platform.persistence.jdbc.base;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.List;
import net.ymate.platform.persistence.jdbc.base.IResultSetHandler;

public abstract class AbstractResultSetHandler<T>
implements IResultSetHandler<T> {
    private int __columnCount;
    private ColumnMeta[] __columnMetas;

    @Override
    public List<T> handle(ResultSet resultSet) throws Exception {
        ResultSetMetaData _metaData = resultSet.getMetaData();
        this.__columnCount = _metaData.getColumnCount();
        this.__columnMetas = new ColumnMeta[this.__columnCount];
        for (int _idx = 0; _idx < this.__columnCount; ++_idx) {
            this.__columnMetas[_idx] = new ColumnMeta(_metaData.getColumnLabel(_idx + 1), _metaData.getColumnType(_idx + 1));
        }
        ArrayList<T> _results = new ArrayList<T>();
        while (resultSet.next()) {
            _results.add(this.__doProcessResultRow(resultSet));
        }
        return _results;
    }

    protected abstract T __doProcessResultRow(ResultSet var1) throws Exception;

    protected int __doGetColumnCount() {
        return this.__columnCount;
    }

    protected ColumnMeta _doGetColumnMeta(int idx) {
        return this.__columnMetas[idx];
    }

    public static class ColumnMeta {
        private final String name;
        private final int type;

        public ColumnMeta(String name, int type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public int getType() {
            return this.type;
        }
    }
}

