/*
 * Decompiled with CFR 0.152.
 */
package net.yesdata.RESP_intepreter;

import java.util.ArrayList;
import java.util.List;
import net.yesdata.RESP_intepreter.ArrayNode;
import net.yesdata.RESP_intepreter.BulkStringNode;
import net.yesdata.RESP_intepreter.ErrorNode;
import net.yesdata.RESP_intepreter.IInterpreter;
import net.yesdata.RESP_intepreter.IRespNode;
import net.yesdata.RESP_intepreter.IntegerNode;
import net.yesdata.RESP_intepreter.RespResponseInterpretedResult;
import net.yesdata.RESP_intepreter.SimpleStringNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRespInterpreter
implements IInterpreter {
    @Override
    public String FormatCommand(String commandString) throws Exception {
        if (commandString.trim().length() == 0) {
            throw new Exception("Command string should not be blank.");
        }
        String[] commands = commandString.split(" ");
        ArrayList<IRespNode> respNodes = new ArrayList<IRespNode>();
        String[] stringArray = commands;
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            String command = stringArray[n2];
            if (command.trim().length() > 0) {
                BulkStringNode node = new BulkStringNode(command);
                respNodes.add(node);
            }
            ++n2;
        }
        ArrayNode resultNode = new ArrayNode(respNodes);
        return resultNode.toRespFormatString();
    }

    @Override
    public String FormatCommand(List<String> commands) throws Exception {
        String commandString = "";
        for (String command : commands) {
            commandString = String.valueOf(commandString) + this.FormatCommand(command);
        }
        return commandString;
    }

    @Override
    public List<IRespNode> IntepretResponse(String response) throws Exception {
        if (response == null || response.length() == 0) {
            throw new Exception("The response could not be blank.");
        }
        ArrayList<IRespNode> responses = new ArrayList<IRespNode>();
        int beginIndex = 0;
        int responseLen = response.length();
        while (beginIndex < responseLen) {
            RespResponseInterpretedResult respResponseInterpretedResult = this.InterpreterDispatcher(response, beginIndex);
            if (respResponseInterpretedResult != null && respResponseInterpretedResult.getRespNode() != null) {
                responses.add(respResponseInterpretedResult.getRespNode());
                beginIndex = respResponseInterpretedResult.getLastIndex();
                continue;
            }
            throw new Exception("Error occurred. Interpreting stoped." + this.FormatErrorTips(beginIndex));
        }
        return responses;
    }

    private RespResponseInterpretedResult InterpreterDispatcher(String response, int beginIndex) throws Exception {
        String startChar = response.substring(beginIndex, beginIndex + 1);
        if (startChar.equals("+")) {
            return this.InterpretSimpleStringResponse(response, beginIndex);
        }
        if (startChar.equals("-")) {
            return this.InterpretErrorStringResponse(response, beginIndex);
        }
        if (startChar.equals(":")) {
            return this.InterpretIntegerResponse(response, beginIndex);
        }
        if (startChar.equals("$")) {
            return this.InterpretBulkStringResponse(response, beginIndex);
        }
        if (startChar.equals("*")) {
            return this.InterpretArrayResponse(response, beginIndex);
        }
        throw new Exception("The first byte '" + startChar + "' is invalid." + this.FormatErrorTips(startChar, beginIndex));
    }

    private RespResponseInterpretedResult InterpretSimpleStringResponse(String response, int beginIndex) throws Exception {
        String startChar = response.substring(beginIndex, beginIndex + 1);
        if (!startChar.equals("+")) {
            throw new Exception("A Simple String command must be started with char '+'.");
        }
        int crlfIndex = response.indexOf("\r\n", beginIndex);
        String body = response.substring(beginIndex + 1, crlfIndex);
        if (body.length() == 0) {
            throw new Exception("No Simple String response founded.");
        }
        RespResponseInterpretedResult respResponseInterpretedResult = new RespResponseInterpretedResult();
        SimpleStringNode respNode = new SimpleStringNode(body);
        int lastIndex = crlfIndex + "\r\n".length();
        respResponseInterpretedResult.setRespNode(respNode);
        respResponseInterpretedResult.setLastIndex(lastIndex);
        return respResponseInterpretedResult;
    }

    private RespResponseInterpretedResult InterpretErrorStringResponse(String response, int beginIndex) throws Exception {
        String startChar = response.substring(beginIndex, beginIndex + 1);
        if (!startChar.equals("-")) {
            throw new Exception("A Error String type must be started with char '+'.");
        }
        int crlfIndex = response.indexOf("\r\n", beginIndex);
        String body = response.substring(beginIndex + 1, crlfIndex);
        if (body.length() == 0) {
            throw new Exception("No Error String response founded.");
        }
        RespResponseInterpretedResult respResponseInterpretedResult = new RespResponseInterpretedResult();
        ErrorNode respNode = new ErrorNode(body);
        int lastIndex = crlfIndex + "\r\n".length();
        respResponseInterpretedResult.setRespNode(respNode);
        respResponseInterpretedResult.setLastIndex(lastIndex);
        return respResponseInterpretedResult;
    }

    private RespResponseInterpretedResult InterpretIntegerResponse(String response, int beginIndex) throws Exception {
        String startChar = response.substring(beginIndex, beginIndex + 1);
        if (!startChar.equals(":")) {
            throw new Exception("A Integer type must be started with char '+'.");
        }
        int crlfIndex = response.indexOf("\r\n", beginIndex);
        String body = response.substring(beginIndex + 1, crlfIndex);
        if (body.length() == 0) {
            throw new Exception("No Integer response founded.");
        }
        int body2Integer = -1;
        try {
            body2Integer = Integer.valueOf(body);
        }
        catch (Exception ex) {
            throw new Exception("The response should be Integer.");
        }
        RespResponseInterpretedResult respResponseInterpretedResult = new RespResponseInterpretedResult();
        IntegerNode respNode = new IntegerNode(body2Integer);
        int lastIndex = crlfIndex + "\r\n".length();
        respResponseInterpretedResult.setRespNode(respNode);
        respResponseInterpretedResult.setLastIndex(lastIndex);
        return respResponseInterpretedResult;
    }

    private RespResponseInterpretedResult InterpretBulkStringResponse(String response, int beginIndex) throws Exception {
        String startChar = response.substring(beginIndex, beginIndex + 1);
        if (!startChar.equals("$")) {
            throw new Exception("A Bulk String type must be started with char '+'.");
        }
        int crlfIndex = response.indexOf("\r\n", beginIndex);
        String sizeStr = response.substring(beginIndex + 1, crlfIndex);
        if (sizeStr.length() == 0) {
            throw new Exception("The size part of Bulk String should not be blank.");
        }
        if (sizeStr.equals("-1")) {
            RespResponseInterpretedResult respResponseInterpretedResult = new RespResponseInterpretedResult();
            BulkStringNode respNode = new BulkStringNode(null);
            int lastIndex = crlfIndex + "\r\n".length();
            respResponseInterpretedResult.setRespNode(respNode);
            respResponseInterpretedResult.setLastIndex(lastIndex);
            return respResponseInterpretedResult;
        }
        int size = -1;
        try {
            size = Integer.valueOf(sizeStr);
        }
        catch (Exception ex) {
            throw new Exception("The size part of Bulk String should not be Integer number.");
        }
        int expectedBodyEndPosition = crlfIndex + "\r\n".length() + size;
        int expectedBodyEndWithCRLFPosition = crlfIndex + "\r\n".length() + size + "\r\n".length();
        if (response.length() < expectedBodyEndWithCRLFPosition) {
            throw new Exception("The response string length is short than bulk string size.");
        }
        int nextCrlfBeginIndex = crlfIndex + "\r\n".length();
        String body = response.substring(nextCrlfBeginIndex, expectedBodyEndPosition);
        if (size > 0 && body.length() == 0) {
            throw new Exception("Bulk String body should not be blank while the size is defined as " + sizeStr + ".");
        }
        if (!String.valueOf(body.length()).equals(sizeStr)) {
            throw new Exception("The size part (" + sizeStr + ") of Bulk String do not quals to the body's size(" + String.valueOf(body.length()) + ").");
        }
        RespResponseInterpretedResult respResponseInterpretedResult = new RespResponseInterpretedResult();
        BulkStringNode respNode = new BulkStringNode(body);
        int lastIndex = expectedBodyEndWithCRLFPosition;
        respResponseInterpretedResult.setRespNode(respNode);
        respResponseInterpretedResult.setLastIndex(lastIndex);
        return respResponseInterpretedResult;
    }

    private RespResponseInterpretedResult InterpretArrayResponse(String response, int beginIndex) throws Exception {
        RespResponseInterpretedResult respResponseInterpretedResult;
        String startChar = response.substring(beginIndex, beginIndex + 1);
        if (!startChar.equals("*")) {
            throw new Exception("A Array type must be started with char '+'.");
        }
        int crlfIndex = response.indexOf("\r\n", beginIndex);
        String sizeStr = response.substring(beginIndex + 1, crlfIndex);
        if (sizeStr.equals("0")) {
            ArrayNode respArrayNode = new ArrayNode(new ArrayList<IRespNode>());
            RespResponseInterpretedResult respResponseInterpretedResult2 = new RespResponseInterpretedResult();
            respResponseInterpretedResult2.setRespNode(respArrayNode);
            int lastIndex = crlfIndex + "\r\n".length();
            respResponseInterpretedResult2.setLastIndex(lastIndex);
            return respResponseInterpretedResult2;
        }
        if (sizeStr.equals("-1")) {
            ArrayNode respArrayNode = new ArrayNode(null);
            RespResponseInterpretedResult respResponseInterpretedResult3 = new RespResponseInterpretedResult();
            respResponseInterpretedResult3.setRespNode(respArrayNode);
            int lastIndex = crlfIndex + "\r\n".length();
            respResponseInterpretedResult3.setLastIndex(lastIndex);
            return respResponseInterpretedResult3;
        }
        int arrayItemsCount = 0;
        try {
            arrayItemsCount = Integer.valueOf(sizeStr);
        }
        catch (Exception ex) {
            throw new Exception("The size part of Array is invalid.");
        }
        int lastIndex = crlfIndex + "\r\n".length();
        ArrayList<IRespNode> tempRespNodes = new ArrayList<IRespNode>();
        int i = 0;
        while (i < arrayItemsCount) {
            respResponseInterpretedResult = this.InterpreterDispatcher(response, lastIndex);
            if (respResponseInterpretedResult != null && respResponseInterpretedResult.getRespNode() != null) {
                tempRespNodes.add(respResponseInterpretedResult.getRespNode());
                lastIndex = respResponseInterpretedResult.getLastIndex();
            }
            ++i;
        }
        ArrayNode respArrayNode = new ArrayNode(tempRespNodes);
        respResponseInterpretedResult = new RespResponseInterpretedResult();
        respResponseInterpretedResult.setRespNode(respArrayNode);
        respResponseInterpretedResult.setLastIndex(lastIndex);
        return respResponseInterpretedResult;
    }

    private String FormatErrorTips(String str, int index) {
        return "Error occurs near by '" + str + "' at position of '" + String.valueOf(index) + "'.";
    }

    private String FormatErrorTips(int index) {
        return "Error occurs at position of '" + String.valueOf(index) + "'.";
    }
}

