/*
 * Decompiled with CFR 0.152.
 */
package net.ximatai.muyun.proxy;

import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.json.JsonObject;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Upstream {
    private final Logger logger = LoggerFactory.getLogger(Upstream.class);
    String url;
    String path;
    int weight;
    HttpClient client;

    public String getPath() {
        return this.path;
    }

    public String getUrl() {
        return this.url;
    }

    public HttpClient getClient() {
        return this.client;
    }

    public int getWeight() {
        return this.weight;
    }

    public Upstream(JsonObject json, Vertx vertx) {
        this(json.getString("url"), json.getInteger("weight", Integer.valueOf(1)), vertx);
    }

    public Upstream(String url, int weight, Vertx vertx) {
        this.url = url;
        this.weight = weight;
        try {
            URL realURL = new URI(this.url).toURL();
            String host = realURL.getHost();
            int port = realURL.getPort();
            this.path = realURL.getPath();
            HttpClientOptions clientOptions = new HttpClientOptions();
            clientOptions.setDefaultHost(host);
            clientOptions.setDefaultPort(port);
            clientOptions.setKeepAlive(true);
            clientOptions.setTryUsePerMessageWebSocketCompression(true);
            if (realURL.getProtocol().equals("https")) {
                clientOptions.setSsl(true);
                clientOptions.setTrustAll(true);
                clientOptions.setDefaultPort(443);
            }
            this.client = vertx.createHttpClient(clientOptions);
        }
        catch (MalformedURLException e) {
            this.logger.error("Malformed URL: {}", (Object)this.url, (Object)e);
        }
        catch (URISyntaxException e) {
            this.logger.error("Invalid URL: {}", (Object)this.url, (Object)e);
        }
    }
}

