/*
 * Decompiled with CFR 0.152.
 */
package net.ximatai.muyun.fileserver;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.FileSystem;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import net.ximatai.muyun.fileserver.FileInfoEntity;
import net.ximatai.muyun.fileserver.FileServerConfig;
import net.ximatai.muyun.fileserver.IFileService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class FileService
implements IFileService {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    FileServerConfig config;
    @Inject
    Vertx vertx;
    private String folderPath;

    @PostConstruct
    public void init() {
        this.folderPath = this.config.uploadPath();
        if (!this.folderPath.endsWith("/") && !this.folderPath.endsWith("\\")) {
            this.folderPath = this.folderPath + "/";
        }
        Path path = Paths.get(this.folderPath, new String[0]);
        try {
            if (Files.notExists(path, new LinkOption[0])) {
                Files.createDirectories(path, new FileAttribute[0]);
                System.out.println("\u6587\u4ef6\u5939\u5df2\u521b\u5efa: " + this.folderPath);
            } else {
                System.out.println("\u6587\u4ef6\u5939\u5df2\u5b58\u5728: " + this.folderPath);
            }
        }
        catch (Exception e) {
            this.logger.error("\u521b\u5efa\u6587\u4ef6\u5939\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public Future<FileInfoEntity> asyncInfo(String id) {
        if (id.contains("@")) {
            id = id.split("@")[0];
        }
        Promise promise = Promise.promise();
        String fileNamePath = this.suffixFileNameWithN(this.folderPath + id);
        String fileContentPath = this.suffixFileNameWithO(this.folderPath + id);
        File fileContent = new File(fileContentPath);
        String finalId = id;
        this.vertx.fileSystem().readFile(fileNamePath, result -> {
            if (result.succeeded()) {
                Buffer buffer = (Buffer)result.result();
                String line = buffer.toString("UTF-8");
                String suffix = line.split("\\.")[1];
                Path path = Paths.get(fileNamePath, new String[0]);
                String createTime = "00:00";
                try {
                    BasicFileAttributes attrs = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
                    FileTime creationTime = attrs.creationTime();
                    createTime = creationTime.toString();
                }
                catch (IOException e) {
                    this.logger.error("Failed to read file attributes", (Throwable)e);
                }
                FileInfoEntity entity = new FileInfoEntity(line, fileContent.length(), suffix, finalId, createTime);
                promise.complete((Object)entity);
            } else {
                this.logger.error("Failed to read file name: " + String.valueOf(result.cause()));
                promise.fail(result.cause());
            }
        });
        return promise.future();
    }

    @Override
    public FileInfoEntity info(String id) {
        CompletableFuture completableFuture = new CompletableFuture();
        this.asyncInfo(id).onSuccess(completableFuture::complete).onFailure(completableFuture::completeExceptionally);
        try {
            return (FileInfoEntity)completableFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            this.logger.error("Failed to get file info", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public String save(File file) {
        return this.save(file, file.getName());
    }

    public String save1(File file, String assignName) {
        String saveId = this.generateBsyUid();
        String saveFileNameUid = this.suffixFileNameWithN(saveId);
        String saveFileContextUid = this.suffixFileNameWithO(saveId);
        FileSystem fileSystem = this.vertx.fileSystem();
        fileSystem.writeFile(this.folderPath + saveFileNameUid, Buffer.buffer((String)assignName));
        fileSystem.copy(file.getAbsolutePath(), this.folderPath + saveFileContextUid);
        fileSystem.delete(file.getAbsolutePath());
        return "%s@%s".formatted(saveId, assignName);
    }

    @Override
    public String save(File file, String assignName) {
        String saveId = this.generateBsyUid();
        String saveFileNameUid = this.suffixFileNameWithN(saveId);
        String saveFileContextUid = this.suffixFileNameWithO(saveId);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.folderPath + saveFileNameUid));){
            writer.write(assignName);
        }
        catch (IOException e) {
            this.logger.error("Failed to write file name", (Throwable)e);
        }
        Path sourcePath = Paths.get(file.getAbsolutePath(), new String[0]);
        Path targetPath = Paths.get(this.folderPath + saveFileContextUid, new String[0]);
        try {
            Files.move(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            this.logger.error("Failed to move file", (Throwable)e);
        }
        return "%s@%s".formatted(saveId, assignName);
    }

    @Override
    public File get(String idOrName) {
        File fileDirectory = new File(this.folderPath);
        File[] files = fileDirectory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.getName().equals(idOrName)) continue;
                return file;
            }
        }
        String id = idOrName;
        if (idOrName.contains("@")) {
            id = id.split("@")[0];
        }
        String nameFile = this.suffixFileNameWithN(id);
        String contentFile = this.suffixFileNameWithO(id);
        String nameFilePath = this.folderPath + nameFile;
        String contentFilePath = this.folderPath + contentFile;
        Path pathN = Paths.get(nameFilePath, new String[0]);
        Path pathO = Paths.get(contentFilePath, new String[0]);
        if (!Files.exists(pathN, new LinkOption[0])) {
            return null;
        }
        try {
            String name = Files.readString(pathN, StandardCharsets.UTF_8);
            byte[] bytes = Files.readAllBytes(pathO);
            File newFile = File.createTempFile(name.split("\\.")[0], "." + name.split("\\.")[1]);
            Files.write(Paths.get(newFile.getPath(), new String[0]), bytes, new OpenOption[0]);
            String indirectPath = newFile.getAbsolutePath().split(name.split("\\.")[0])[0];
            String uid = this.generateBsyUid();
            String directoryPath = indirectPath + uid;
            File directory = new File(directoryPath);
            boolean result = directory.mkdirs();
            Path sourcePath = Paths.get(newFile.getAbsolutePath(), new String[0]);
            Path targetDir = Paths.get(directory.getAbsolutePath(), new String[0]);
            Path targetPath = targetDir.resolve(name);
            Files.move(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING);
            return targetPath.toFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean delete(String id) {
        if (id.contains("@")) {
            id = id.split("@")[0];
        }
        String deleteNamePath = this.suffixFileNameWithN(this.folderPath + id);
        String deleteContentPath = this.suffixFileNameWithO(this.folderPath + id);
        File fileN = new File(deleteNamePath);
        File fileO = new File(deleteContentPath);
        this.vertx.fileSystem().delete(deleteNamePath, res -> {
            if (res.succeeded()) {
                this.logger.info("FileName deleted successfully: {}", (Object)deleteNamePath);
            } else {
                this.logger.error("Failed to delete file: {}", (Object)deleteNamePath, (Object)res.cause());
            }
        });
        this.vertx.fileSystem().delete(deleteContentPath, res -> {
            if (res.succeeded()) {
                this.logger.info("FileContent deleted successfully: {}", (Object)deleteContentPath);
            } else {
                this.logger.error("Failed to delete file: {}", (Object)deleteContentPath, (Object)res.cause());
            }
        });
        return fileN.exists() || fileO.exists();
    }

    private String generateBsyUid() {
        UUID uid = UUID.randomUUID();
        return "bsy-" + String.valueOf(uid);
    }
}

