/*
 * Decompiled with CFR 0.152.
 */
package net.ximatai.muyun.fileserver;

import io.quarkus.runtime.Startup;
import io.quarkus.runtime.configuration.MemorySizeConverter;
import io.quarkus.vertx.web.RouteFilter;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BodyHandler;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import net.ximatai.muyun.fileserver.FileServerConfig;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@Startup
@ApplicationScoped
public class FileServerRegister {
    @Inject
    FileServerConfig config;
    @ConfigProperty(name="quarkus.http.limits.max-body-size")
    String maxBodySize;
    MemorySizeConverter converter = new MemorySizeConverter();

    private String getUploadPath() {
        Object uploadPath = this.config.uploadPath();
        if (!((String)uploadPath).endsWith("/") && !((String)uploadPath).endsWith("\\")) {
            uploadPath = (String)uploadPath + "/";
        }
        return uploadPath;
    }

    @RouteFilter(value=10)
    void filter(RoutingContext context) {
        BodyHandler.create().setUploadsDirectory(this.getUploadPath()).setBodyLimit(this.converter.convert(this.maxBodySize).asLongValue()).handle((Object)context);
    }
}

