/*
 * Decompiled with CFR 0.152.
 */
package net.ximatai.muyun.fileserver;

import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.FileUpload;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import java.io.File;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import net.ximatai.muyun.fileserver.FileServerConfig;
import net.ximatai.muyun.fileserver.IFileService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class FileServer {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    String originalFileName;
    @Inject
    FileServerConfig config;
    @Inject
    Vertx vertx;
    @Inject
    IFileService fileService;

    private String getRootPath() {
        Object rootPath = this.config.pagePath();
        if (!((String)rootPath).startsWith("/")) {
            rootPath = "/" + (String)rootPath;
        }
        if (!((String)rootPath).endsWith("/")) {
            rootPath = (String)rootPath + "/";
        }
        return rootPath;
    }

    private String getUploadPath() {
        Object uploadPath = this.config.uploadPath();
        if (!((String)uploadPath).endsWith("/") && !((String)uploadPath).endsWith("\\")) {
            uploadPath = (String)uploadPath + "/";
        }
        return uploadPath;
    }

    void init(@Observes Router router) {
        router.get(this.getRootPath() + "index").handler(this::indexFunc);
        router.post(this.getRootPath() + "upload").handler(this::upload);
        router.get(this.getRootPath() + "download/:id").handler(this::download);
        router.get(this.getRootPath() + "delete/:id").handler(this::delete);
        router.get(this.getRootPath() + "info/:id").handler(this::info);
    }

    private void indexFunc(RoutingContext ctx) {
        ctx.response().putHeader("content-type", "text/html").end("        <!DOCTYPE html>\n        <html lang=\"en\">\n        <head>\n            <meta charset=\"UTF-8\">\n            <title>Title</title>\n        </head>\n        <body>\n        <form enctype=\"multipart/form-data\" action=\"/fileServer/upload\" method=\"post\">\n            <input name=\"files1\"  type=\"file\" multiple />\n            <button type=\"submit\">\u63d0\u4ea4</button>\n        </form>\n        </body>\n        </html>\n");
    }

    private void upload(RoutingContext ctx) {
        ctx.response().setChunked(true);
        for (FileUpload f : ctx.fileUploads()) {
            String uploadedFileName = f.uploadedFileName();
            this.originalFileName = f.fileName();
            this.logger.info("uploaded file name: {}", (Object)uploadedFileName);
            File file = new File(uploadedFileName);
            String id = this.fileService.save(file, this.originalFileName);
            ctx.response().putHeader("Content-Type", "text/plain;charset=utf-8").write(id);
        }
        ctx.response().end();
    }

    private void download(RoutingContext ctx) {
        String id = ctx.pathParam("id");
        File fileObtained = this.fileService.get(id);
        if (id.contains("@") && id.length() > 35) {
            id = id.split("@")[0];
            String nameFile = this.fileService.suffixFileNameWithN(id);
            String nameFilePath = this.getUploadPath() + nameFile;
            this.vertx.fileSystem().readFile(nameFilePath, result -> {
                if (result.succeeded()) {
                    Buffer buffer = (Buffer)result.result();
                    if (fileObtained.exists()) {
                        ctx.response().putHeader("Content-Disposition", "attachment; filename*=UTF-8''" + URLEncoder.encode(buffer.toString(), StandardCharsets.UTF_8)).putHeader("Content-type", "application/octet-stream").sendFile(fileObtained.getPath());
                        fileObtained.deleteOnExit();
                    }
                } else {
                    this.logger.error("Failed to read file name: " + String.valueOf(result.cause()));
                    ctx.fail(result.cause());
                }
            });
        } else {
            ctx.response().putHeader("Content-Disposition", "attachment; filename*=UTF-8''" + URLEncoder.encode(id, StandardCharsets.UTF_8)).putHeader("Content-type", "application/octet-stream").sendFile(fileObtained.getPath());
        }
    }

    private void delete(RoutingContext ctx) {
        String id = ctx.pathParam("id");
        boolean isDeleted = this.fileService.delete(id);
        if (isDeleted) {
            ctx.response().end("Successfully deleted.");
        } else {
            ctx.response().end("Failed to delete.");
        }
    }

    private void info(RoutingContext ctx) {
        String id = ctx.pathParam("id");
        this.fileService.asyncInfo(id).onSuccess(entity -> ctx.response().putHeader("Content-Type", "application/json").end(entity.toJson().toString())).onFailure(err -> {
            this.logger.error("Failed to get file info: " + String.valueOf(err));
            ctx.fail(err);
        });
    }
}

