/*
 * Decompiled with CFR 0.152.
 */
package net.ximatai.muyun.database.tool;

import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

public class DateTool {
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public static Date stringToSqlDate(String dateString) {
        if (dateString == null || dateString.isEmpty()) {
            throw new IllegalArgumentException("Date string cannot be null or empty.");
        }
        try {
            LocalDate localDate = LocalDate.parse(dateString.substring(0, 10), DATE_FORMATTER);
            return Date.valueOf(localDate);
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException("Invalid date format: " + dateString);
        }
    }

    public static Timestamp stringToSqlTimestamp(String dateString) {
        if (dateString == null || ((String)dateString).isEmpty()) {
            return null;
        }
        try {
            if (((String)dateString).length() == 10) {
                dateString = (String)dateString + " 00:00:00";
            }
            LocalDateTime localDateTime = LocalDateTime.parse((CharSequence)dateString, DATE_TIME_FORMATTER);
            return Timestamp.valueOf(localDateTime);
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException("Invalid datetime format: " + (String)dateString);
        }
    }

    public static Timestamp handleDateTimestamp(Object value) {
        if ("".equals(value)) {
            return null;
        }
        if (value instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)value;
            return Timestamp.valueOf(localDateTime);
        }
        if (value instanceof Date) {
            Date date = (Date)value;
            return new Timestamp(date.getTime());
        }
        if (value instanceof String) {
            String str = (String)value;
            return DateTool.stringToSqlTimestamp(str);
        }
        throw new IllegalArgumentException("Unsupported type: " + value.getClass().getName());
    }
}

