/*
 * Decompiled with CFR 0.152.
 */
package net.ximatai.muyun.database.metadata;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DBColumn {
    private String name;
    private String description;
    private String type;
    private String defaultValue;
    private String indexName;
    private boolean nullable;
    private boolean primaryKey;
    private boolean unique;
    private boolean indexed;
    private boolean sequence;
    private static String regex = "'([^']*)'";
    private static Pattern pattern = Pattern.compile(regex);

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Object getDefaultValue() {
        return this.extractDefaultContent(this.defaultValue);
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(boolean primaryKey) {
        this.primaryKey = primaryKey;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public boolean isSequence() {
        return this.sequence;
    }

    public void setSequence(boolean sequence) {
        this.sequence = sequence;
    }

    public void setSequence() {
        this.sequence = true;
    }

    public void setUnique() {
        this.unique = true;
    }

    public void setNullable() {
        this.nullable = true;
    }

    public void setPrimaryKey() {
        this.primaryKey = true;
    }

    public boolean isIndexed() {
        return this.indexed;
    }

    public void setIndexed(boolean indexed) {
        this.indexed = indexed;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public Object extractDefaultContent(String input) {
        if (input == null) {
            return null;
        }
        if (this.getType().equalsIgnoreCase("bool")) {
            return Boolean.parseBoolean(input);
        }
        if (this.getType().startsWith("int")) {
            return Integer.parseInt(input);
        }
        Matcher matcher = pattern.matcher(input);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return input;
    }
}

