/*
 * Decompiled with CFR 0.152.
 */
package net.ximatai.muyun.database;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import net.ximatai.muyun.database.exception.MyDatabaseException;
import net.ximatai.muyun.database.metadata.DBInfo;
import net.ximatai.muyun.database.metadata.DBSchema;
import net.ximatai.muyun.database.metadata.DBTable;
import org.jdbi.v3.core.Jdbi;

public interface IDBInfoProvider {
    public Jdbi getJdbi();

    public void setJdbi(Jdbi var1);

    public void resetDBInfo();

    default public DBInfo getDBInfo() {
        return (DBInfo)this.getJdbi().withHandle(handle -> {
            Connection connection = handle.getConnection();
            try {
                DatabaseMetaData metaData = connection.getMetaData();
                DBInfo info = new DBInfo(metaData.getDatabaseProductName());
                try (ResultSet schemasRs = metaData.getSchemas();){
                    while (schemasRs.next()) {
                        info.addSchema(new DBSchema(schemasRs.getString("TABLE_SCHEM")));
                    }
                }
                try (ResultSet tablesRs = metaData.getTables(null, null, null, new String[]{"TABLE"});){
                    while (tablesRs.next()) {
                        String tableName = tablesRs.getString("TABLE_NAME");
                        String schema = tablesRs.getString("TABLE_SCHEM");
                        DBTable table = new DBTable(this.getJdbi()).setName(tableName).setSchema(schema);
                        info.getSchema(schema).addTable(table);
                    }
                }
                return info;
            }
            catch (Exception e) {
                throw new MyDatabaseException(e.getMessage(), MyDatabaseException.Type.READ_METADATA_ERROR);
            }
        });
    }
}

