/*
 * Decompiled with CFR 0.152.
 */
package net.ximatai.muyun.database.metadata;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.ximatai.muyun.database.builder.TableBase;
import net.ximatai.muyun.database.metadata.DBColumn;
import org.jdbi.v3.core.Jdbi;

public class DBTable
extends TableBase {
    private Jdbi jdbi;
    private Map<String, DBColumn> columnMap;

    public DBTable(Jdbi jdbi) {
        this.jdbi = jdbi;
    }

    @Override
    public DBTable setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public DBTable setSchema(String schema) {
        this.schema = schema;
        return this;
    }

    public Map<String, DBColumn> getColumnMap() {
        if (this.columnMap == null) {
            this.jdbi.useHandle(handle -> {
                Connection connection = handle.getConnection();
                try {
                    DBColumn column;
                    DatabaseMetaData metaData = connection.getMetaData();
                    HashMap<String, DBColumn> columnMap = new HashMap<String, DBColumn>();
                    try (ResultSet rs = metaData.getColumns(null, this.schema, this.name, null);){
                        while (rs.next()) {
                            DBColumn column2 = new DBColumn();
                            column2.setName(rs.getString("COLUMN_NAME"));
                            column2.setType(rs.getString("TYPE_NAME"));
                            column2.setNullable(rs.getInt("NULLABLE") == 1);
                            String defaultValue = rs.getString("COLUMN_DEF");
                            column2.setDefaultValue(defaultValue);
                            if ("YES".equals(rs.getString("IS_AUTOINCREMENT"))) {
                                column2.setSequence();
                            }
                            if (defaultValue != null && defaultValue.startsWith("nextval(")) {
                                column2.setSequence();
                            }
                            column2.setDescription(rs.getString("REMARKS"));
                            columnMap.put(column2.getName(), column2);
                        }
                    }
                    rs = metaData.getPrimaryKeys(null, this.schema, this.name);
                    try {
                        while (rs.next()) {
                            String primaryKeyColumn = rs.getString("COLUMN_NAME");
                            column = (DBColumn)columnMap.get(primaryKeyColumn);
                            if (column == null) continue;
                            column.setPrimaryKey(true);
                        }
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    rs = metaData.getIndexInfo(null, this.schema, this.name, false, false);
                    try {
                        while (rs.next()) {
                            String columnName = rs.getString("COLUMN_NAME");
                            column = (DBColumn)columnMap.get(columnName);
                            if (column == null) continue;
                            column.setIndexName(rs.getString("INDEX_NAME"));
                            column.setIndexed(true);
                            if (rs.getBoolean("NON_UNIQUE")) continue;
                            column.setUnique(true);
                        }
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    this.columnMap = columnMap;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return this.columnMap;
    }

    public boolean contains(String column) {
        if (column == null) {
            return false;
        }
        return this.getColumn(column.toLowerCase()) != null;
    }

    public DBColumn getColumn(String column) {
        Objects.requireNonNull(column);
        return this.getColumnMap().get(column.toLowerCase());
    }

    public void resetColumns() {
        this.columnMap = null;
    }
}

