/*
 * Decompiled with CFR 0.152.
 */
package net.ximatai.muyun.database.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.ximatai.muyun.database.builder.Column;
import net.ximatai.muyun.database.builder.ColumnType;
import net.ximatai.muyun.database.builder.Index;
import net.ximatai.muyun.database.builder.TableBase;

public class TableWrapper
extends TableBase {
    private String comment;
    private List<TableBase> inherits = new ArrayList<TableBase>();
    private List<Column> columns = new ArrayList<Column>();
    private List<Index> indexes = new ArrayList<Index>();
    private Column primaryKey;

    public static TableWrapper withName(String name) {
        return new TableWrapper(name);
    }

    @Override
    public TableWrapper setSchema(String schema) {
        this.schema = schema;
        return this;
    }

    public TableWrapper setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public TableWrapper setInherits(List<TableBase> inherits) {
        this.inherits = inherits;
        return this;
    }

    public TableWrapper setInherit(TableBase inherit) {
        this.inherits = List.of(inherit);
        return this;
    }

    public TableWrapper setPrimaryKey(String name) {
        this.primaryKey = Column.of(name).setPrimaryKey().setType(ColumnType.VARCHAR).setNullable(false);
        return this;
    }

    public TableWrapper setPrimaryKey(Column column) {
        this.primaryKey = column;
        return this;
    }

    public TableWrapper addIndex(String columnName) {
        this.addIndex(columnName, false);
        return this;
    }

    public TableWrapper addIndex(String columnName, boolean unique) {
        Column col = this.getColumns().stream().filter(column -> column.getName().equals(columnName)).findFirst().orElse(null);
        if (col == null) {
            throw new IllegalArgumentException("No such column: " + columnName);
        }
        this.indexes.add(new Index(columnName, unique));
        return this;
    }

    public TableWrapper addIndex(List<String> columns) {
        columns.forEach(columnName -> {
            Column col = this.getColumns().stream().filter(column -> column.getName().equals(columnName)).findFirst().orElse(null);
            if (col == null) {
                throw new IllegalArgumentException("No such column: " + columnName);
            }
        });
        this.addIndex(columns, false);
        return this;
    }

    public TableWrapper addIndex(List<String> columns, boolean unique) {
        this.indexes.add(new Index(columns, unique));
        return this;
    }

    public TableWrapper addColumn(String columnName) {
        this.columns.add(Column.of(columnName));
        return this;
    }

    public TableWrapper addColumn(String columnName, String comment) {
        this.columns.add(Column.of(columnName).setComment(comment));
        return this;
    }

    public TableWrapper addColumn(String columnName, String comment, Object defaultValue) {
        this.columns.add(Column.of(columnName).setComment(comment).setDefaultValue(defaultValue));
        return this;
    }

    public TableWrapper addColumn(Column column) {
        if (this.primaryKey != null && Objects.equals(column.getName(), this.primaryKey.getName())) {
            throw new IllegalArgumentException("Primary key already exists");
        }
        this.columns.add(column);
        if (column.isUnique()) {
            this.addIndex(column.getName(), true);
        } else if (column.isIndexed()) {
            this.addIndex(column.getName());
        }
        return this;
    }

    public String getComment() {
        return this.comment;
    }

    public List<TableBase> getInherits() {
        return this.inherits;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public List<Index> getIndexes() {
        return this.indexes;
    }

    public Column getPrimaryKey() {
        return this.primaryKey;
    }

    public TableWrapper(String name) {
        this.name = name;
    }
}

