/*
 * Decompiled with CFR 0.152.
 */
package net.ximatai.muyun.database.builder;

import java.util.List;
import java.util.Objects;
import net.ximatai.muyun.database.IDatabaseOperations;
import net.ximatai.muyun.database.builder.Column;
import net.ximatai.muyun.database.builder.ColumnType;
import net.ximatai.muyun.database.builder.IColumnTypeTransform;
import net.ximatai.muyun.database.builder.Index;
import net.ximatai.muyun.database.builder.TableBase;
import net.ximatai.muyun.database.builder.TableWrapper;
import net.ximatai.muyun.database.exception.MyDatabaseException;
import net.ximatai.muyun.database.metadata.DBColumn;
import net.ximatai.muyun.database.metadata.DBInfo;
import net.ximatai.muyun.database.metadata.DBSchema;
import net.ximatai.muyun.database.metadata.DBTable;

public class TableBuilder {
    DBInfo info;
    IDatabaseOperations db;

    public TableBuilder(IDatabaseOperations db) {
        this.db = db;
        this.info = db.getDBInfo();
    }

    public boolean build(TableWrapper wrapper) {
        List<TableBase> inherits;
        boolean result = false;
        String schema = wrapper.getSchema();
        String name = wrapper.getName();
        if (this.info.getSchema(schema) == null) {
            this.db.execute("create schema if not exists " + wrapper.getSchema());
            this.info.addSchema(new DBSchema(wrapper.getSchema()));
        }
        if ((inherits = wrapper.getInherits()) != null && !inherits.isEmpty()) {
            inherits.forEach(inherit -> {
                if (!this.info.getSchema(inherit.getSchema()).containsTable(inherit.getName())) {
                    throw new MyDatabaseException("Table " + String.valueOf(inherit) + " does not exist");
                }
            });
        }
        if (!this.info.getSchema(wrapper.getSchema()).containsTable(wrapper.getName())) {
            this.db.execute("create table %s.%s\n(\n    a_temp_column int\n) %s ;\n".formatted(schema, name, this.inheritSQL(inherits)));
            result = true;
            this.info.getSchema(schema).addTable(new DBTable(this.db.getJdbi()).setName(name).setSchema(schema));
        }
        DBTable dbTable = this.info.getSchema(schema).getTable(wrapper.getName());
        if (wrapper.getComment() != null) {
            this.db.execute("COMMENT ON table %s.%s is '%s'".formatted(schema, name, wrapper.getComment()));
        }
        if (wrapper.getPrimaryKey() != null) {
            this.checkAndBuildColumn(dbTable, wrapper.getPrimaryKey());
            dbTable.resetColumns();
        }
        wrapper.getColumns().forEach(column -> this.checkAndBuildColumn(dbTable, (Column)column));
        if (result) {
            this.db.execute("alter table %s.%s drop column a_temp_column;".formatted(schema, name));
        }
        dbTable.resetColumns();
        wrapper.getIndexes().forEach(index -> this.checkAndBuildIndex(dbTable, (Index)index));
        dbTable.resetColumns();
        return result;
    }

    private boolean checkAndBuildColumn(DBTable dbTable, Column column) {
        DBColumn dbColumn;
        boolean result = false;
        String name = column.getName();
        ColumnType dataType = column.getType();
        String type = this.getColumnTypeTransform().transform(dataType);
        Object defaultValue = column.getDefaultValue();
        String comment = column.getComment();
        boolean sequence = column.isSequence();
        boolean nullable = column.isNullable();
        boolean primaryKey = column.isPrimaryKey();
        if (!dbTable.contains(name)) {
            this.db.execute("alter table %s.%s add %s %s".formatted(dbTable.getSchema(), dbTable.getName(), name, type));
            dbTable.resetColumns();
            result = true;
        }
        if (!(dbColumn = dbTable.getColumn(name)).isSequence() && !Objects.equals(dbColumn.getDefaultValue(), defaultValue)) {
            String value;
            if ("varchar".equalsIgnoreCase(type) && defaultValue instanceof String && !(value = (String)defaultValue).contains("(") && !value.contains(")")) {
                defaultValue = "'%s'".formatted(value);
            }
            this.db.execute("alter table %s.%s alter column %s set default %s".formatted(dbTable.getSchema(), dbTable.getName(), name, defaultValue));
        }
        if (!Objects.equals(dbColumn.getDescription(), comment)) {
            this.db.execute("comment on column %s.%s.%s is '%s'".formatted(dbTable.getSchema(), dbTable.getName(), name, comment));
        }
        if (dbColumn.isNullable() != nullable) {
            String flag = nullable ? "drop" : "set";
            this.db.execute("alter table %s.%s alter column %s %s not null".formatted(dbTable.getSchema(), dbTable.getName(), name, flag));
        }
        if (dbColumn.isSequence() != sequence) {
            String seq = "%s_%s_seq".formatted(dbTable.getName(), name);
            if (sequence) {
                this.db.execute("create sequence if not exists %s.%s;".formatted(dbTable.getSchema(), seq));
                this.db.execute("alter table %s.%s alter column %s set default nextval('%s.%s')".formatted(dbTable.getSchema(), dbTable.getName(), name, dbTable.getSchema(), seq));
            } else {
                this.db.execute("alter table %s.%s alter column %s drop default".formatted(dbTable.getSchema(), dbTable.getName(), name));
                this.db.execute("drop sequence if exists %s.%s;".formatted(dbTable.getSchema(), seq));
            }
        }
        if (primaryKey && !dbColumn.isPrimaryKey()) {
            this.db.execute("alter table %s.%s add primary key (%s)\n".formatted(dbTable.getSchema(), dbTable.getName(), name));
        }
        return result;
    }

    private boolean checkAndBuildIndex(DBTable dbTable, Index index) {
        boolean result = false;
        List<String> columns = index.getColumns();
        int size = columns.size();
        if (size == 1) {
            String col = columns.getFirst();
            DBColumn dbColumn = dbTable.getColumn(col);
            if (index.isUnique() && !dbColumn.isUnique()) {
                String indexName = "%s_%s_uindex".formatted(dbTable.getName(), col);
                this.db.execute("create unique index if not exists %s on %s.%s(%s);".formatted(indexName, dbTable.getSchema(), dbTable.getName(), col));
                result = true;
            } else if (!index.isUnique() && !dbColumn.isIndexed()) {
                String indexName = "%s_%s_index".formatted(dbTable.getName(), col);
                this.db.execute("create index if not exists %s on %s.%s(%s);".formatted(indexName, dbTable.getSchema(), dbTable.getName(), col));
                result = true;
            }
        } else if (size > 0) {
            if (index.isUnique()) {
                String indexName = "%s_%s_uindex".formatted(dbTable.getName(), String.join((CharSequence)"_", columns));
                this.db.execute("create unique index if not exists %s on %s.%s(%s);".formatted(indexName, dbTable.getSchema(), dbTable.getName(), String.join((CharSequence)",", columns)));
                result = true;
            } else {
                String indexName = "%s_%s_index".formatted(dbTable.getName(), String.join((CharSequence)"_", columns));
                this.db.execute("create index if not exists %s on %s.%s(%s);".formatted(indexName, dbTable.getSchema(), dbTable.getName(), String.join((CharSequence)",", columns)));
                result = true;
            }
        }
        return result;
    }

    private String inheritSQL(List<TableBase> inherits) {
        if (inherits == null || inherits.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder("inherits (");
        inherits.forEach(inherit -> builder.append("%s.%s".formatted(inherit.getSchema(), inherit.getName())));
        builder.append(")");
        return builder.toString();
    }

    private IColumnTypeTransform getColumnTypeTransform() {
        String dbName;
        switch (dbName = this.info.getName().toUpperCase()) {
            case "POSTGRESQL": {
                return IColumnTypeTransform.POSTGRES;
            }
        }
        return null;
    }
}

