/*
 * Decompiled with CFR 0.152.
 */
package net.ximatai.muyun.database;

import java.sql.Array;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import net.ximatai.muyun.database.IDBInfoProvider;
import net.ximatai.muyun.database.metadata.DBColumn;
import net.ximatai.muyun.database.metadata.DBTable;

public interface IDatabaseOperations
extends IDBInfoProvider {
    default public Map<String, ?> transformDataForDB(DBTable dbTable, Map<String, ?> data) {
        return data;
    }

    default public String buildInsertSql(String schema, String tableName, Map<String, ?> params) {
        DBTable dbTable = this.getDBInfo().getSchema(schema).getTable(tableName);
        Objects.requireNonNull(dbTable);
        Map<String, DBColumn> columnMap = dbTable.getColumnMap();
        StringJoiner columns = new StringJoiner(", ", "(", ")");
        StringJoiner values = new StringJoiner(", ", "(", ")");
        params.keySet().forEach(key -> {
            if (columnMap.containsKey(key)) {
                columns.add((CharSequence)key);
                values.add(":" + key);
            }
        });
        return "insert into %s.%s %s values %s".formatted(schema, tableName, columns, values);
    }

    default public String buildUpdateSql(String schema, String tableName, Map<String, ?> params, String pk) {
        DBTable dbTable = this.getDBInfo().getSchema(schema).getTable(tableName);
        Objects.requireNonNull(dbTable);
        Map<String, DBColumn> columnMap = dbTable.getColumnMap();
        StringJoiner setClause = new StringJoiner(", ");
        params.keySet().forEach(key -> {
            if (columnMap.containsKey(key)) {
                setClause.add(key + "=:" + key);
            }
        });
        return "update %s.%s set %s where %s = :%s".formatted(schema, tableName, setClause, pk, pk);
    }

    default public Object insertItem(String schema, String tableName, Map<String, ?> params) {
        DBTable table = this.getDBInfo().getSchema(schema).getTable(tableName);
        Map<String, ?> transformed = this.transformDataForDB(table, params);
        return this.insert(this.buildInsertSql(schema, tableName, transformed), transformed, "id", String.class);
    }

    default public Object insertList(String schema, String tableName, List<? extends Map<String, ?>> list) {
        Objects.requireNonNull(list, "The list must not be null");
        if (list.isEmpty()) {
            throw new IllegalArgumentException("The list must not be empty");
        }
        DBTable table = this.getDBInfo().getSchema(schema).getTable(tableName);
        List<Map> transformedList = list.stream().map(it -> this.transformDataForDB(table, (Map<String, ?>)it)).toList();
        return this.batchInsert(this.buildInsertSql(schema, tableName, transformedList.getFirst()), transformedList, "id", String.class);
    }

    default public Object updateItem(String schema, String tableName, Map<String, ?> params) {
        DBTable table = this.getDBInfo().getSchema(schema).getTable(tableName);
        Map<String, ?> transformed = this.transformDataForDB(table, params);
        return this.update(this.buildUpdateSql(schema, tableName, transformed, "id"), transformed);
    }

    default public Object deleteItem(String schema, String tableName, String id) {
        DBTable dbTable = this.getDBInfo().getSchema(schema).getTable(tableName);
        Objects.requireNonNull(dbTable);
        return this.delete("DELETE FROM %s.%s WHERE id=:id".formatted(schema, tableName), Map.of("id", id));
    }

    public <T> Object insert(String var1, Map<String, ?> var2, String var3, Class<T> var4);

    public <T> Object batchInsert(String var1, List<? extends Map<String, ?>> var2, String var3, Class<T> var4);

    public Object row(String var1, Object ... var2);

    public Object row(String var1, List<?> var2);

    public Object row(String var1, Map<String, ?> var2);

    public Object row(String var1);

    public Object query(String var1, Map<String, ?> var2);

    public Object query(String var1, List<?> var2);

    public Object query(String var1, Object ... var2);

    public Object query(String var1);

    public Object update(String var1, Map<String, ?> var2);

    public Object update(String var1, Object ... var2);

    public Object delete(String var1, Map<String, ?> var2);

    public Object delete(String var1, Object ... var2);

    public Object delete(String var1, List<?> var2);

    public Object execute(String var1);

    public Array toArray(List var1, String var2);
}

