package net.xiaolanglang.blog.common.utils;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import net.xiaolanglang.blog.common.exception.JsonConversionException;

import java.io.IOException;

/**
 * blog json utils
 * Created by gaoyang on 16/1/19.
 */
@SuppressWarnings("unused")
public class JsonUtils {
    private static final ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    public static <T> T covert(Object source, Class view, Class<T> targetClass) {
        if (source == null) {
            return null;
        }
        try {
            return objectMapper.readValue(objectMapper.writerWithView(view).writeValueAsBytes(source), targetClass);
        } catch (IOException e) {
            throw new JsonConversionException();
        }
    }
}
