/*
 * Decompiled with CFR 0.152.
 */
package security.utils;

import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import security.filters.AuthenticationData;

public class SecurityAuthUtil {
    private static final String KEY_DATA = "SECURITY-AUTH-DATA";

    public static void authorized(AuthenticationData authenticationData) {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        requestAttributes.setAttribute(KEY_DATA, (Object)authenticationData, 0);
    }

    public static long getAccountId() {
        AuthenticationData data = SecurityAuthUtil.getData();
        if (data != null) {
            return data.getId();
        }
        return 0L;
    }

    public static String getToken() {
        AuthenticationData data = SecurityAuthUtil.getData();
        if (data != null) {
            return data.getToken();
        }
        return null;
    }

    public static long getSid() {
        AuthenticationData data = SecurityAuthUtil.getData();
        if (data != null) {
            return data.getSid();
        }
        return 0L;
    }

    public static AuthenticationData getData() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        return (AuthenticationData)requestAttributes.getAttribute(KEY_DATA, 0);
    }
}

