/*
 * Decompiled with CFR 0.152.
 */
package security.service;

import framework.config.UserConfig;
import framework.security.AuthService;
import security.utils.SecurityAuthUtil;

public class AuthServiceDefault
implements AuthService {
    private UserConfig userConfig;

    public AuthServiceDefault(UserConfig userConfig) {
        this.userConfig = userConfig;
    }

    public boolean isSupperAdmin() {
        Long superAdminId = this.userConfig.getSuperAdminId();
        if (superAdminId == null) {
            return false;
        }
        if (superAdminId == 0L) {
            return false;
        }
        return superAdminId.equals(this.getAccountId());
    }

    public long getAccountId() {
        return SecurityAuthUtil.getAccountId();
    }

    public boolean isAuthenticated() {
        long accountId = this.getAccountId();
        return accountId > 0L;
    }

    public String getSecret() {
        return SecurityAuthUtil.getToken();
    }

    public long getSid() {
        return SecurityAuthUtil.getSid();
    }

    public UserConfig getUserConfig() {
        return this.userConfig;
    }
}

