/*
 * Decompiled with CFR 0.152.
 */
package security.filters;

import framework.security.FunctionPermission;

public class FunctionPermissionHandler {
    private String[] permissionArray;
    private final FunctionPermission functionPermission;

    public FunctionPermissionHandler(FunctionPermission functionPermission) {
        this.functionPermission = functionPermission;
        this.splitPermissionArray(functionPermission.getPermission());
    }

    public boolean hasPermission(String permission) {
        if (permission == null) {
            return false;
        }
        if ("".equals(permission)) {
            return false;
        }
        String[] arr = this.permissionArray;
        if (arr == null) {
            return permission.equals(this.functionPermission.getPermission());
        }
        if (arr.length == 1) {
            return permission.equals(this.functionPermission.getPermission());
        }
        for (String s : arr) {
            if (!permission.equals(s)) continue;
            return true;
        }
        return false;
    }

    private void splitPermissionArray(String permission) {
        this.permissionArray = permission == null ? null : permission.split(",");
    }

    public FunctionPermission getFunctionPermission() {
        return this.functionPermission;
    }
}

