package security.utils;

import framework.config.SecurityConfig;
import org.springframework.util.StringUtils;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

/**
 * 安全组件TOKEN工具
 */
public class SecurityTokenUtil {
    /**
     * 获取令牌
     *
     * @param request
     * @param securityConfig
     * @return
     */
    public static String getRequestToken(HttpServletRequest request, SecurityConfig securityConfig) {
        boolean enableBearerToken = securityConfig.getEnableBearerToken() != null && securityConfig.getEnableBearerToken();
        boolean enableBasicAuth = securityConfig.getEnableBasicAuth() != null && securityConfig.getEnableBasicAuth();
        String tokenParamName = securityConfig.getTokenParamName();
        return getRequestToken(request, enableBearerToken, enableBasicAuth, tokenParamName);
    }

    /**
     * 获取令牌
     *
     * @param request
     * @param enableBasicAuth
     * @param enableBearerToken
     * @param tokenParamName
     * @return
     */
    public static String getRequestToken(HttpServletRequest request, boolean enableBearerToken, boolean enableBasicAuth, String tokenParamName) {
        String requestToken = request.getHeader("Authorization");
        String returnToken;
        boolean hasToken = StringUtils.hasLength(requestToken);
        if (hasToken && enableBearerToken && requestToken.startsWith("Bearer ")) {
            returnToken = "TOKEN " + requestToken.substring(7);
        } else if (hasToken && enableBasicAuth && requestToken.startsWith("Basic ")) {
            returnToken = "BASIC " + requestToken.substring(6);
        } else if (StringUtils.hasLength(request.getParameter(tokenParamName))) {
            returnToken = "TOKEN " + request.getParameter(tokenParamName);
        } else {
            returnToken = null;
            if (request.getCookies() != null) {
                for (Cookie cookie : request.getCookies()) {
                    if (tokenParamName.equals(cookie.getName())) {
                        if (cookie.getValue() != null) {
                            returnToken = "TOKEN " + cookie.getValue().trim();
                        }
                        break;
                    }
                }
            }
        }
        return returnToken;
    }

}
