/*
 * Decompiled with CFR 0.152.
 */
package security.utils;

import framework.config.SecurityConfig;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.StringUtils;

public class SecurityTokenUtil {
    public static String getRequestToken(HttpServletRequest request, SecurityConfig securityConfig) {
        boolean enableBearerToken = securityConfig.getEnableBearerToken() != null && securityConfig.getEnableBearerToken() != false;
        boolean enableBasicAuth = securityConfig.getEnableBasicAuth() != null && securityConfig.getEnableBasicAuth() != false;
        String tokenParamName = securityConfig.getTokenParamName();
        return SecurityTokenUtil.getRequestToken(request, enableBearerToken, enableBasicAuth, tokenParamName);
    }

    public static String getRequestToken(HttpServletRequest request, boolean enableBearerToken, boolean enableBasicAuth, String tokenParamName) {
        String returnToken;
        String requestToken = request.getHeader("Authorization");
        boolean hasToken = StringUtils.hasLength((String)requestToken);
        if (hasToken && enableBearerToken && requestToken.startsWith("Bearer ")) {
            returnToken = "TOKEN " + requestToken.substring(7);
        } else if (hasToken && enableBasicAuth && requestToken.startsWith("Basic ")) {
            returnToken = "BASIC " + requestToken.substring(6);
        } else if (StringUtils.hasLength((String)request.getParameter(tokenParamName))) {
            returnToken = "TOKEN " + request.getParameter(tokenParamName);
        } else {
            returnToken = null;
            if (request.getCookies() != null) {
                for (Cookie cookie : request.getCookies()) {
                    if (!tokenParamName.equals(cookie.getName())) continue;
                    if (cookie.getValue() == null) break;
                    returnToken = "TOKEN " + cookie.getValue().trim();
                    break;
                }
            }
        }
        return returnToken;
    }
}

