/*
 * Decompiled with CFR 0.152.
 */
package security.filters;

import framework.config.SecurityConfig;
import framework.crypto.AESCrypto;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import security.filters.AuthenticationData;
import security.utils.SecurityAuthUtil;
import security.utils.SecurityTokenUtil;

public class AuthIdentityServletFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(AuthIdentityServletFilter.class);
    private SecurityConfig securityConfig;
    private AESCrypto aesCrypto;
    public final String authIdentityHeaderName;
    public final String authIdentityHeaderNameSid;

    public AuthIdentityServletFilter(SecurityConfig securityConfig, AESCrypto aesCrypto) {
        this.securityConfig = securityConfig;
        this.aesCrypto = aesCrypto;
        String identityHeader = securityConfig.getAuthIdentityHeader();
        if (!StringUtils.hasText((String)identityHeader)) {
            throw new IllegalArgumentException("Not configuration sys.security.auth_identity_header");
        }
        this.authIdentityHeaderName = identityHeader;
        this.authIdentityHeaderNameSid = identityHeader + "-SID";
    }

    private long getAuthIdentity(HttpServletRequest servletRequest) {
        String identity = servletRequest.getHeader(this.authIdentityHeaderName);
        if (StringUtils.hasText((String)identity)) {
            return Long.parseLong(identity);
        }
        return 0L;
    }

    private long getAuthSid(HttpServletRequest servletRequest) {
        String sid = servletRequest.getHeader(this.authIdentityHeaderNameSid);
        if (StringUtils.hasText((String)sid)) {
            return Long.parseLong(sid);
        }
        return 0L;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        long id = this.getAuthIdentity(request);
        long sid = this.getAuthSid(request);
        if (id == 0L && this.getSecurityConfig().getDebugAccountId() != null) {
            id = this.getSecurityConfig().getDebugAccountId();
        }
        String token = SecurityTokenUtil.getRequestToken(request, this.getSecurityConfig());
        SecurityAuthUtil.authorized(new AuthenticationData(id, token, sid));
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public SecurityConfig getSecurityConfig() {
        return this.securityConfig;
    }
}

