package security.filters;

public interface AuthenticationHandler {

    /**
     * TOKEN令牌获取方法
     *
     * @return
     */
    String getRequestToken();

    /**
     * 获取请求路径
     *
     * @return
     */
    String getRequestPath();

    /**
     * 获取请求方法
     *
     * @return
     */
    String getRequestMethod();

    /**
     * 令牌过期提醒
     *
     * @param seconds
     */
    void tokenExpiredReminder(int seconds);

    /**
     * 令牌有效期输出
     *
     * @param seconds
     */
    void tokenBalanceOutput(int seconds);
}
