/*
 * Decompiled with CFR 0.152.
 */
package security.utils;

import framework.config.SecurityConfig;
import org.springframework.util.StringUtils;

public class SecurityCookieUtil {
    public static StringBuffer buildCookie(SecurityConfig securityConfig, String name, String value, String path, Integer expires) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(name).append("=").append(value);
        if (StringUtils.hasText((String)securityConfig.getCookieDomain())) {
            buffer.append("; Domain").append("=").append(securityConfig.getCookieDomain());
        }
        if (StringUtils.hasText((String)securityConfig.getCookiePath())) {
            buffer.append("; Path").append("=").append(securityConfig.getCookiePath());
        } else if (StringUtils.hasText((String)path)) {
            buffer.append("; Path").append("=").append(path);
        }
        if (expires != null && expires > 0) {
            buffer.append("; Max-Age").append("=").append(expires);
        } else if (securityConfig.getCookieMaxAge() != null && securityConfig.getCookieMaxAge() > 0) {
            buffer.append("; Max-Age").append("=").append(securityConfig.getCookieMaxAge());
        }
        if (securityConfig.getCookieSecure() != null && securityConfig.getCookieSecure().booleanValue()) {
            buffer.append("; Secure");
        }
        if (securityConfig.getCookieHttpOnly() != null && securityConfig.getCookieHttpOnly().booleanValue()) {
            buffer.append("; HttpOnly");
        }
        if (StringUtils.hasText((String)securityConfig.getCookieSameSite())) {
            buffer.append("; SameSite").append("=").append(securityConfig.getCookieSameSite());
        }
        return buffer;
    }
}

